/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.lang.Numbers;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.grade.config.GradeRateConfig;
import org.openurp.edu.grade.config.GradeRateItem;

public class GradingModeHelper {
    private Map<String, GradingMode> gradeStyles = CollectUtils.newHashMap();
    private Map<String, GradingMode> styles = CollectUtils.newHashMap();
    private GradingMode defaultNumberStyle;
    private EntityDao entityDao;

    private GradingModeHelper() {
    }

    public void init(Integer defaultNumberStyleId) {
        List configs = this.entityDao.getAll(GradeRateConfig.class);
        for (GradeRateConfig config : configs) {
            if (config.getGradingMode().isNumerical()) continue;
            List<GradeRateItem> items = config.getItems();
            for (GradeRateItem item : items) {
                if (null == item.getGrade()) continue;
                this.gradeStyles.put(item.getGrade(), config.getGradingMode());
            }
        }
        List mss = this.entityDao.getAll(GradingMode.class);
        for (GradingMode style : mss) {
            this.styles.put(style.getCode(), style);
        }
        if (null != defaultNumberStyleId) {
            this.defaultNumberStyle = (GradingMode)this.entityDao.get(GradingMode.class, (Serializable)defaultNumberStyleId);
        }
    }

    public GradingMode styleForCode(String code) {
        GradingMode style = this.styles.get(code);
        if (null == style) {
            return this.defaultNumberStyle;
        }
        return style;
    }

    public GradingMode styleForScore(String score) {
        GradingMode style = this.gradeStyles.get(score);
        if (null == style && Numbers.isDigits((String)score)) {
            style = this.defaultNumberStyle;
        }
        return style;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

