/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.collection.Order;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.GradeType;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.service.StdGradeService;

public class StdGradeServiceImpl
implements StdGradeService {
    private EntityDao entityDao;

    @Override
    public Student getStdByCode(String stdCode, Project project, List<Department> departments, EntityDao entityDao) {
        OqlBuilder query = OqlBuilder.from(Student.class, (String)"std");
        query.where("std.code=:code", (Object)stdCode);
        if (project == null || CollectUtils.isEmpty(departments)) {
            query.where("std is null");
        } else {
            query.where("std.project = :project", (Object)project);
            query.where("std.state.department in (:departments)", departments);
        }
        List stds = entityDao.search((QueryBuilder)query);
        if (CollectUtils.isEmpty((Collection)stds)) {
            return null;
        }
        if (stds.size() == 1) {
            return (Student)stds.get(0);
        }
        throw new RuntimeException("\u6570\u636e\u5f02\u5e38");
    }

    @Override
    public OqlBuilder<GradeType> buildGradeTypeQuery() {
        OqlBuilder query = OqlBuilder.from(GradeType.class, (String)"gradeType");
        query.where("gradeType.id not in (:ids)", (Object)new Integer[]{GradeType.FINAL_ID});
        query.where("gradeType.beginOn <= :now and (gradeType.endOn is null or gradeType.endOn >= :now)", (Object)new Date());
        query.orderBy(Order.parse((String)"gradeType.code asc"));
        return query;
    }

    @Override
    public Object[] getStatus(String crn, String stdId, String semesterId, EntityDao entityDao) {
        OqlBuilder query = OqlBuilder.from(CourseTaker.class, (String)"taker");
        query.where("taker.clazz.crn = :crn", (Object)crn);
        query.where("taker.std.id = :stdId", (Object)new Long(stdId));
        query.where("not exists(from " + CourseGrade.class.getName() + " grade where grade.std.id = :stdId and grade.clazz.crn=:crn)", (Object)new Long(stdId), (Object)crn);
        query.where("taker.clazz.semester.id = :semesterId", (Object)new Long(semesterId));
        query.select("taker.clazz.id,taker.clazz.course.code,taker.clazz.course.name,taker.clazz.gradeState.gradingMode.id,taker.clazz.gradeState.gradingMode.name");
        List takers = entityDao.search((QueryBuilder)query);
        if (CollectUtils.isEmpty((Collection)takers)) {
            return null;
        }
        if (takers.size() == 1) {
            return (Object[])takers.get(0);
        }
        throw new RuntimeException("\u6570\u636e\u5f02\u5e38");
    }

    @Override
    public boolean checkStdGradeExists(Student std, Semester semester, Course course, Project project) {
        OqlBuilder builder = OqlBuilder.from(CourseGrade.class, (String)"courseGrade");
        builder.where("courseGrade.semester = :semester", (Object)semester);
        builder.where("courseGrade.project = :project", (Object)project);
        builder.where("courseGrade.std = :student", (Object)std);
        builder.where("courseGrade.course = :course", (Object)course);
        List courseGrades = this.entityDao.search((QueryBuilder)builder);
        return courseGrades.size() > 0;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

