/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.time.Stopwatch;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.service.CourseGradeProvider;

public class CourseGradeProviderImpl
extends BaseServiceImpl
implements CourseGradeProvider {
    @Override
    public Map<Long, Boolean> getPassedStatus(Student std) {
        OqlBuilder query = OqlBuilder.from(CourseGrade.class, (String)"cg");
        query.where("cg.std = :std", (Object)std);
        query.select("cg.course.id,cg.passed");
        List rs = this.entityDao.search((QueryBuilder)query);
        Map courseMap = CollectUtils.newHashMap();
        for (Object[] obj : rs) {
            Long courseId = (Long)obj[0];
            if (null != obj[1]) {
                if (courseMap.containsKey(courseId) && Boolean.TRUE.equals(courseMap.get(courseId))) continue;
                courseMap.put(courseId, (Boolean)obj[1]);
                continue;
            }
            courseMap.put(courseId, Boolean.FALSE);
        }
        return courseMap;
    }

    @Override
    public List<CourseGrade> getPublished(Student std, Semester ... semesters) {
        OqlBuilder query = OqlBuilder.from(CourseGrade.class, (String)"grade");
        query.where("grade.std = :std", (Object)std);
        query.where("grade.status =:status", (Object)2);
        if (null != semesters && semesters.length > 0) {
            query.where("grade.semester in(:semesters)", (Object)semesters);
        }
        query.orderBy("grade.semester.beginOn");
        return this.entityDao.search((QueryBuilder)query);
    }

    @Override
    public List<CourseGrade> getAll(Student std, Semester ... semesters) {
        OqlBuilder query = OqlBuilder.from(CourseGrade.class, (String)"grade");
        query.where("grade.std = :std", (Object)std);
        if (null != semesters && semesters.length > 0) {
            query.where("grade.semester in(:semesters)", (Object)semesters);
        }
        query.orderBy("grade.semester.beginOn");
        return this.entityDao.search((QueryBuilder)query);
    }

    @Override
    public Map<Student, List<CourseGrade>> getPublished(Collection<Student> stds, Semester ... semesters) {
        Stopwatch sw = new Stopwatch();
        sw.start();
        OqlBuilder query = OqlBuilder.from(CourseGrade.class, (String)"grade");
        query.where("grade.std in (:stds)", stds);
        query.where("grade.status =:status", (Object)2);
        if (null != semesters && semesters.length > 0) {
            query.where("grade.semester in(:semesters)", (Object)semesters);
        }
        List allGrades = this.entityDao.search((QueryBuilder)query);
        Map gradeMap = CollectUtils.newHashMap();
        for (Student std : stds) {
            gradeMap.put(std, new ArrayList());
        }
        for (CourseGrade g : allGrades) {
            ((List)gradeMap.get(g.getStd())).add(g);
        }
        this.logger.debug("Get {}'s grade using {}", (Object)stds.size(), (Object)sw);
        return gradeMap;
    }

    @Override
    public Map<Student, List<CourseGrade>> getAll(Collection<Student> stds, Semester ... semesters) {
        OqlBuilder query = OqlBuilder.from(CourseGrade.class, (String)"grade");
        query.where("grade.std in (:stds)", stds);
        if (null != semesters && semesters.length > 0) {
            query.where("grade.semester in(:semesters)", (Object)semesters);
        }
        List allGrades = this.entityDao.search((QueryBuilder)query);
        Map gradeMap = CollectUtils.newHashMap();
        for (Student std : stds) {
            gradeMap.put(std, new ArrayList());
        }
        for (CourseGrade g : allGrades) {
            ((List)gradeMap.get(g.getStd())).add(g);
        }
        return gradeMap;
    }
}

