/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.script.ExpressionEvaluator;
import org.openurp.base.edu.model.Project;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.grade.config.GradeRateConfig;
import org.openurp.edu.grade.config.GradeRateItem;
import org.openurp.edu.grade.course.service.GradeRateService;
import org.openurp.edu.grade.course.service.ScoreConverter;

public class GradeRateServiceImpl
extends BaseServiceImpl
implements GradeRateService {
    private ExpressionEvaluator expressionEvaluator;

    @Override
    public ScoreConverter getConverter(Project project, GradingMode gradingMode) {
        if (null == project || null == gradingMode) {
            throw new IllegalArgumentException("require project and grade and grading option ");
        }
        OqlBuilder builder = OqlBuilder.from(GradeRateConfig.class, (String)"config").where("config.project=:project and config.gradingMode=:gradingMode", (Object)project, (Object)gradingMode).cacheable();
        GradeRateConfig config = (GradeRateConfig)((Object)this.entityDao.uniqueResult((QueryBuilder)builder));
        if (null == config) {
            throw new RuntimeException("Cannot find ScoreConverter for " + gradingMode.getName());
        }
        return new ScoreConverter(config, this.expressionEvaluator);
    }

    @Override
    public Map<GradingMode, List<GradeRateItem>> getGradeItems(Project project) {
        OqlBuilder builder = OqlBuilder.from(GradeRateConfig.class, (String)"config").where("config.project=:project and config.gradingMode.numerical=false", (Object)project);
        List configs = this.entityDao.search((QueryBuilder)builder);
        HashMap datas = new HashMap();
        for (GradeRateConfig config : configs) {
            HashMap<String, GradeRateItem> items = (HashMap<String, GradeRateItem>)datas.get((Object)config.getGradingMode());
            if (null == items) {
                items = new HashMap<String, GradeRateItem>();
                datas.put(config.getGradingMode(), items);
            }
            for (GradeRateItem item : config.getItems()) {
                items.put(item.getGrade(), item);
            }
        }
        HashMap<GradingMode, List<GradeRateItem>> rs = new HashMap<GradingMode, List<GradeRateItem>>();
        for (Map.Entry entry : datas.entrySet()) {
            rs.put((GradingMode)((Object)entry.getKey()), new ArrayList(((Map)entry.getValue()).values()));
        }
        return rs;
    }

    @Override
    public List<GradingMode> getGradingModes(Project project) {
        OqlBuilder builder = OqlBuilder.from(GradeRateConfig.class, (String)"config").where("config.project=:project", (Object)project).select("config.gradingMode").cacheable();
        return this.entityDao.search((QueryBuilder)builder);
    }

    public void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }
}

