/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.listeners;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Course;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.plan.model.AuditCourseResult;
import org.openurp.edu.grade.plan.model.AuditGroupResult;
import org.openurp.edu.grade.plan.model.AuditPlanResult;
import org.openurp.edu.grade.plan.service.AuditPlanContext;
import org.openurp.edu.grade.plan.service.AuditPlanListener;
import org.openurp.edu.grade.plan.service.StdGrade;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.PlanCourse;

public class PlanAuditCommonElectiveListener
implements AuditPlanListener {
    @Override
    public void endPlanAudit(AuditPlanContext context) {
        AuditPlanResult result = context.getResult();
        StdGrade stdGrade = context.getStdGrade();
        CourseType electiveType = context.getSetting().getConvertTarget();
        AuditGroupResult groupResult = result.getGroupResult(electiveType);
        if (null == groupResult) {
            AuditGroupResult groupRs = new AuditGroupResult();
            groupRs.setCourseType(electiveType);
            groupRs.setName(electiveType.getName());
            groupRs.setSubCount((short)0);
            groupRs.setIndexno("99.99");
            groupResult = groupRs;
            result.addGroupResult(groupResult);
        }
        Collection<Course> restCourses = stdGrade.getRestCourses();
        for (Course course : restCourses) {
            AuditCourseResult courseResult = groupResult.getCourseResult(course);
            if (null == courseResult) {
                courseResult = new AuditCourseResult();
                groupResult.addCourseResult(courseResult);
            }
            courseResult.setCourse(course);
            List<CourseGrade> grades = stdGrade.useGrades(course);
            if (!grades.isEmpty() && !((Integer)grades.get(0).getCourseType().getId()).equals(electiveType.getId())) {
                courseResult.addRemark("\u539f" + grades.get(0).getCourseType().getName());
            }
            courseResult.checkPassed(grades);
            groupResult.updateCourseResult(courseResult);
        }
        this.processConvertCredits(groupResult, result, context);
        groupResult.checkPassed(true);
    }

    protected void processConvertCredits(AuditGroupResult target, AuditPlanResult result, AuditPlanContext context) {
        Set parents = CollectUtils.newHashSet();
        Set sibling = CollectUtils.newHashSet();
        for (AuditGroupResult start = target.getParent(); null != start && !parents.contains((Object)start); start = start.getParent()) {
            parents.add(start);
        }
        AuditGroupResult parent = target.getParent();
        if (null != parent) {
            sibling.addAll(parent.getChildren());
            sibling.remove((Object)target);
        }
        float otherConverted = 0.0f;
        float siblingConverted = 0.0f;
        for (AuditGroupResult gr : result.getGroupResults()) {
            if (!context.getSetting().isConvertable(gr.getCourseType()) || gr.equals((Object)target) || parents.contains((Object)gr)) continue;
            if (sibling.contains((Object)gr)) {
                siblingConverted += gr.isPassed() ? gr.getAuditStat().getPassedCredits() - gr.getAuditStat().getRequiredCredits() : 0.0f;
                continue;
            }
            if (null != gr.getParent()) continue;
            otherConverted += gr.isPassed() ? gr.getAuditStat().getPassedCredits() - gr.getAuditStat().getRequiredCredits() : 0.0f;
        }
        target.getAuditStat().setConvertedCredits(otherConverted + siblingConverted);
        for (AuditGroupResult r : parents) {
            r.getAuditStat().setConvertedCredits(otherConverted);
        }
    }

    @Override
    public boolean startPlanAudit(AuditPlanContext context) {
        return true;
    }

    @Override
    public boolean startCourseAudit(AuditPlanContext context, AuditGroupResult groupResult, PlanCourse planCourse) {
        return true;
    }

    @Override
    public boolean startGroupAudit(AuditPlanContext context, CourseGroup courseGroup, AuditGroupResult groupResult) {
        return true;
    }
}

