/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.major.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.std.model.Squad;
import org.openurp.code.std.model.StdType;
import org.openurp.edu.program.major.service.MajorPlanGenParameter;
import org.openurp.edu.program.major.service.MajorPlanService;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.MajorCourseGroup;
import org.openurp.edu.program.model.MajorPlan;
import org.openurp.edu.program.model.MajorPlanCourse;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.model.ProgramDoc;
import org.openurp.edu.program.model.ProgramDocSection;
import org.openurp.edu.program.model.TermCampus;
import org.openurp.edu.program.plan.dao.PlanCommonDao;
import org.openurp.edu.program.plan.dao.PlanCourseGroupCommonDao;
import org.openurp.edu.program.plan.service.MajorPlanQueryBuilder;
import org.openurp.edu.program.plan.util.ProgramNamingHelper;

public class MajorPlanServiceImpl
extends BaseServiceImpl
implements MajorPlanService {
    private PlanCommonDao planCommonDao;
    private PlanCourseGroupCommonDao planCourseGroupCommonDao;

    @Override
    public MajorPlan genMajorPlan(MajorPlan sourcePlan, MajorPlanGenParameter genParameter) throws Exception {
        Program program = sourcePlan.getProgram();
        Program newProgram = this.newProgram(program, genParameter);
        newProgram.setStartTerm(program.getStartTerm());
        newProgram.setEndTerm(program.getEndTerm());
        this.entityDao.saveOrUpdate(new Object[]{newProgram});
        this.tryCloneDoc(program, newProgram);
        MajorPlan newPlan = (MajorPlan)sourcePlan.clone();
        newPlan.setId(null);
        newPlan.setCredits(sourcePlan.getCredits());
        newPlan.setCreditHours(sourcePlan.getCreditHours());
        newPlan.setHourRatios(sourcePlan.getHourRatios());
        newPlan.setUpdatedAt(new Date());
        if (genParameter != null) {
            newProgram.setStartTerm(genParameter.getStartTerm());
            newProgram.setEndTerm(genParameter.getEndTerm());
        }
        newPlan.setGroups(new ArrayList<CourseGroup>());
        newPlan.setProgram(newProgram);
        this.entityDao.saveOrUpdate(new Object[]{newPlan});
        if (sourcePlan != null) {
            for (CourseGroup sourceCourseGroup : sourcePlan.getTopCourseGroups()) {
                this.planCourseGroupCommonDao.copyCourseGroup(sourceCourseGroup, null, newPlan, MajorCourseGroup.class, MajorPlanCourse.class);
            }
        }
        this.planCommonDao.saveOrUpdatePlan(newPlan);
        return newPlan;
    }

    @Override
    public List<MajorPlan> genMajorPlans(Collection<MajorPlan> plans, MajorPlanGenParameter partialParams) throws Exception {
        ArrayList<MajorPlan> genedPlans = new ArrayList<MajorPlan>(plans.size());
        for (MajorPlan plan : plans) {
            MajorPlanGenParameter t_param = new MajorPlanGenParameter();
            t_param.setGrade(partialParams.getGrade());
            t_param.setBeginOn(partialParams.getBeginOn());
            t_param.setEndOn(partialParams.getEndOn());
            t_param.setDuration(plan.getProgram().getDuration().floatValue());
            t_param.setStartTerm(plan.getProgram().getStartTerm());
            t_param.setEndTerm(plan.getProgram().getEndTerm());
            t_param.setDegree(plan.getProgram().getDegree());
            t_param.setDepartment(plan.getProgram().getDepartment());
            t_param.setDirection(plan.getProgram().getDirection());
            t_param.setLevel(plan.getProgram().getLevel());
            t_param.setMajor(plan.getProgram().getMajor());
            t_param.getStdTypes().addAll(plan.getProgram().getStdTypes());
            t_param.setStudyType(plan.getProgram().getStudyType());
            t_param.setName(ProgramNamingHelper.name(t_param, this.entityDao));
            genedPlans.add(this.genMajorPlan(plan, t_param));
        }
        return genedPlans;
    }

    @Override
    public Set<String> getUnusedCourseTypeNames(MajorPlan plan) {
        return this.planCommonDao.getUnusedCourseTypeNames(plan);
    }

    @Override
    public void removeMajorPlan(MajorPlan plan) {
        this.planCommonDao.removePlan(plan);
    }

    @Override
    public void saveOrUpdateMajorPlan(MajorPlan plan) {
        this.planCommonDao.saveOrUpdatePlan(plan);
    }

    @Override
    public float statPlanCredits(Long planId) {
        return this.statPlanCredits((MajorPlan)this.entityDao.get(MajorPlan.class, (Serializable)planId));
    }

    @Override
    public float statPlanCredits(MajorPlan plan) {
        for (CourseGroup group : plan.getTopCourseGroups()) {
            this.planCourseGroupCommonDao.updateGroupTreeCredits(group);
        }
        float res = this.planCommonDao.statPlanCredits(plan);
        plan.setCredits(res);
        this.entityDao.saveOrUpdate(new Object[]{plan});
        return res;
    }

    @Override
    public boolean hasCourse(MajorCourseGroup cgroup, Course course) {
        return this.planCommonDao.hasCourse(cgroup, course);
    }

    @Override
    public boolean hasCourse(MajorCourseGroup cgroup, Course course, PlanCourse planCourse) {
        return this.planCommonDao.hasCourse(cgroup, course, planCourse);
    }

    public void setPlanCommonDao(PlanCommonDao planCommonDao) {
        this.planCommonDao = planCommonDao;
    }

    @Override
    public MajorPlan getMajorPlanByAdminClass(Squad clazz) {
        List res = this.entityDao.search(MajorPlanQueryBuilder.build(clazz));
        return CollectUtils.isEmpty((Collection)res) ? null : (MajorPlan)res.get(0);
    }

    @Override
    public List<MajorPlanCourse> getPlanCourses(MajorPlan plan) {
        if (CollectUtils.isEmpty(plan.getGroups())) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MajorPlanCourse> planCourses = new ArrayList<MajorPlanCourse>();
        for (MajorCourseGroup majorCourseGroup : plan.getGroups()) {
            planCourses.addAll(majorCourseGroup.getPlanCourses());
        }
        return planCourses;
    }

    private void tryCloneDoc(Program from, Program to) {
        OqlBuilder q = OqlBuilder.from(ProgramDoc.class, (String)"pd");
        q.where("pd.program=:program", (Object)from);
        for (ProgramDoc od : this.entityDao.search((QueryBuilder)q)) {
            ProgramDoc nd = new ProgramDoc();
            nd.setProgram(to);
            nd.setDocLocale(od.getDocLocale());
            nd.setUpdatedAt(new Date());
            for (ProgramDocSection ods : od.getSections()) {
                ProgramDocSection nds = new ProgramDocSection();
                nds.setIndexno(ods.getIndexno());
                nds.setDoc(nd);
                nds.setContents(ods.getContents());
                nds.setName(ods.getName());
                nd.getSections().add(nds);
            }
            this.entityDao.saveOrUpdate(new Object[]{nd});
        }
    }

    private Program newProgram(Program originalProgram, MajorPlanGenParameter param) {
        try {
            Program newProgram = (Program)originalProgram.clone();
            newProgram.setDegreeCourses(new HashSet<Course>(originalProgram.getDegreeCourses()));
            newProgram.setTermCampuses(new ArrayList<TermCampus>());
            for (TermCampus tc : originalProgram.getTermCampuses()) {
                TermCampus ntc = new TermCampus();
                ntc.setProgram(newProgram);
                ntc.setTerms(tc.getTerms());
                ntc.setCampus(tc.getCampus());
                newProgram.getTermCampuses().add(ntc);
            }
            Date now = new Date();
            newProgram.setId(null);
            newProgram.setName(param.getName());
            newProgram.setStatus(AuditStatus.UNSUBMITTED);
            newProgram.setUpdatedAt(now);
            newProgram.setDuration(Float.valueOf(param.getDuration()));
            newProgram.setGrade(param.getGrade());
            newProgram.setBeginOn(param.getBeginOn());
            newProgram.setEndOn(param.getEndOn());
            if (param.getDegree() == null || param.getDegree().isTransient()) {
                newProgram.setDegree(null);
            } else {
                newProgram.setDegree(param.getDegree());
            }
            if (param.getDepartment() == null || param.getDepartment().isTransient()) {
                newProgram.setDepartment(null);
            } else {
                newProgram.setDepartment(param.getDepartment());
            }
            if (param.getDirection() == null || param.getDirection().isTransient()) {
                newProgram.setDirection(null);
            } else {
                newProgram.setDirection(param.getDirection());
            }
            if (param.getLevel() == null || param.getLevel().isTransient()) {
                newProgram.setLevel(null);
            } else {
                newProgram.setLevel(param.getLevel());
            }
            if (param.getMajor() == null || param.getMajor().isTransient()) {
                newProgram.setMajor(null);
            } else {
                newProgram.setMajor(param.getMajor());
            }
            newProgram.setStdTypes(new HashSet<StdType>());
            newProgram.getStdTypes().addAll(param.getStdTypes());
            if (param.getStudyType() == null || param.getStudyType().isTransient()) {
                newProgram.setStudyType(null);
            } else {
                newProgram.setStudyType(param.getStudyType());
            }
            newProgram.setDegreeCourses(new HashSet<Course>());
            newProgram.getDegreeCourses().addAll(param.getDegreeCourses());
            return newProgram;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPlanCourseGroupCommonDao(PlanCourseGroupCommonDao planCourseGroupCommonDao) {
        this.planCourseGroupCommonDao = planCourseGroupCommonDao;
    }
}

