/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.edu.model;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.NumberIdTimeObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.edu.model.MajorDirection;
import org.openurp.base.edu.model.MajorDiscipline;
import org.openurp.base.edu.model.MajorJournal;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.SchoolLength;
import org.openurp.base.model.Department;
import org.openurp.code.edu.model.EducationLevel;

@Entity(name="org.openurp.base.edu.model.Major")
@Cacheable
@Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Major
extends NumberIdTimeObject<Long> {
    private static final long serialVersionUID = 7360406731828210066L;
    @Column(unique=true)
    @NotNull
    @Size(max=32)
    protected String code;
    @NotNull
    @Size(max=100)
    protected String name;
    @Size(max=255)
    protected String enName;
    @Size(max=500)
    protected String remark;
    @NotNull
    protected Date beginOn;
    protected Date endOn;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @OneToMany(mappedBy="major", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<MajorDirection> directions = CollectUtils.newHashSet();
    @OneToMany(mappedBy="major", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<MajorJournal> journals = CollectUtils.newArrayList();
    @OneToMany(mappedBy="major", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<MajorDiscipline> disciplines = CollectUtils.newArrayList();
    @OneToMany(mappedBy="major", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<SchoolLength> schoolLengths = CollectUtils.newArrayList();
    @Size(max=30)
    private String shortName;

    public Major() {
    }

    public Major(Long id) {
        super((Number)id);
    }

    public Set<MajorDirection> getDirections() {
        return this.directions;
    }

    public void setDirections(Set<MajorDirection> directions) {
        this.directions = directions;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public List<MajorJournal> getJournals() {
        return this.journals;
    }

    public void setJournals(List<MajorJournal> journals) {
        this.journals = journals;
    }

    public List<EducationLevel> getLevels() {
        HashSet<EducationLevel> educations = new HashSet<EducationLevel>();
        for (MajorJournal j : this.journals) {
            educations.add(j.getLevel());
        }
        return new ArrayList<EducationLevel>(educations);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEnName() {
        return this.enName;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public String getDisciplineCode(Date endOn) {
        for (MajorDiscipline md : this.disciplines) {
            if (!md.isMatchIn(endOn)) continue;
            return md.getDisciplineCode();
        }
        return "";
    }

    public Set<Department> getDepartments() {
        Set departs = CollectUtils.newHashSet();
        for (MajorJournal md : this.getJournals()) {
            departs.add(md.getDepart());
        }
        return departs;
    }

    public Set<Department> getValidDepartments() {
        Set departs = CollectUtils.newHashSet();
        java.util.Date now = new java.util.Date();
        for (MajorJournal md : this.getJournals()) {
            if (!now.after(md.getBeginOn()) || (md.getEndOn() == null || !now.before(md.getEndOn())) && md.getEndOn() != null) continue;
            departs.add(md.getDepart());
        }
        return departs;
    }

    public Set<Department> getValidDepartments(java.util.Date time) {
        Set departs = CollectUtils.newHashSet();
        for (MajorJournal md : this.getJournals()) {
            if (!time.after(md.getBeginOn()) || (md.getEndOn() == null || !time.before(md.getEndOn())) && md.getEndOn() != null) continue;
            departs.add(md.getDepart());
        }
        return departs;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public List<MajorDiscipline> getDisciplines() {
        return this.disciplines;
    }

    public void setDisciplines(List<MajorDiscipline> disciplines) {
        this.disciplines = disciplines;
    }

    public List<SchoolLength> getSchoolLengths() {
        return this.schoolLengths;
    }

    public void setSchoolLengths(List<SchoolLength> schoolLengths) {
        this.schoolLengths = schoolLengths;
    }
}

