/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.edu.model;

import java.sql.Date;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.NumberIdTimeObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.MajorDirectionJournal;
import org.openurp.base.edu.model.Project;

@Entity(name="org.openurp.base.edu.model.MajorDirection")
@Cacheable
@Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MajorDirection
extends NumberIdTimeObject<Long> {
    private static final long serialVersionUID = -5678184739078006225L;
    @Column(unique=true)
    @NotNull
    @Size(max=32)
    protected String code;
    @NotNull
    @Size(max=100)
    protected String name;
    @Size(max=255)
    protected String enName;
    @Size(max=500)
    protected String remark;
    @NotNull
    protected Date beginOn;
    protected Date endOn;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Major major;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @OneToMany(mappedBy="direction", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<MajorDirectionJournal> journals = CollectUtils.newArrayList();

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public MajorDirection() {
    }

    public MajorDirection(Long id) {
        super((Number)id);
    }

    public Major getMajor() {
        return this.major;
    }

    public void setMajor(Major major) {
        this.major = major;
    }

    public List<MajorDirectionJournal> getJournals() {
        return this.journals;
    }

    public void setJournals(List<MajorDirectionJournal> journals) {
        this.journals = journals;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEnName() {
        return this.enName;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }
}

