/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.dao.hibernate.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.lang.Strings;
import org.beangle.orm.hibernate.HibernateEntityDao;
import org.openurp.base.edu.model.Semester;
import org.openurp.edu.clazz.dao.ClazzCRNGenerator;
import org.openurp.edu.clazz.model.Clazz;

public class ClazzCRNGeneratorImpl
extends HibernateEntityDao
implements ClazzCRNGenerator {
    public static final String initSeqNo = "0001";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void genClazzSeqNo(Clazz clazz) {
        if (Strings.isNotEmpty((CharSequence)clazz.getCrn())) {
            return;
        }
        ClazzCRNGeneratorImpl clazzCRNGeneratorImpl = this;
        synchronized (clazzCRNGeneratorImpl) {
            String hql = MessageFormat.format("select crn from " + Clazz.class.getName() + " clazz where clazz.semester.id={0} and clazz.project.id={1} and length(clazz.crn)=4 order by crn", ((Integer)clazz.getSemester().getId()).toString(), ((Integer)clazz.getProject().getId()).toString());
            List crns = this.search(hql, new Object[0]);
            int newNo = 0;
            for (String seqNo : crns) {
                if (seqNo.matches(".*[^\\d]+.*")) continue;
                if (Numbers.toInt((String)seqNo) - newNo >= 2) break;
                newNo = Numbers.toInt((String)seqNo);
            }
            clazz.setCrn(Strings.repeat((String)"0", (int)(4 - String.valueOf(++newNo).length())) + newNo);
        }
    }

    @Override
    public void genClazzSeqNos(Collection<Clazz> clazzes) {
        Map semesterTasks = CollectUtils.newHashMap();
        for (Clazz clazz : clazzes) {
            if (!Strings.isEmpty((CharSequence)clazz.getCrn())) continue;
            ArrayList<Clazz> matches = (ArrayList<Clazz>)semesterTasks.get(clazz.getSemester());
            if (null == matches) {
                matches = new ArrayList<Clazz>();
                semesterTasks.put(clazz.getSemester(), matches);
            }
            matches.add(clazz);
        }
        for (Semester semester : semesterTasks.keySet()) {
            this.genClazzSeqNos(semester, (Collection)semesterTasks.get(semester));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genClazzSeqNos(Semester semester, Collection tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        ClazzCRNGeneratorImpl clazzCRNGeneratorImpl = this;
        synchronized (clazzCRNGeneratorImpl) {
            Iterator iter1 = tasks.iterator();
            Integer projectId = null;
            if (iter1.hasNext()) {
                projectId = (Integer)((Clazz)iter1.next()).getProject().getId();
            }
            String hql = MessageFormat.format("select crn from org.openurp.edu.clazz.model.Clazz clazz where clazz.semester.id={0} and clazz.project.id={1} order by crn", ((Integer)semester.getId()).toString(), projectId.toString());
            List allSeqNos = this.search(hql, new Object[0]);
            int newSeqNo = 0;
            int seq = 0;
            int allocated = 0;
            Iterator taskIter = tasks.iterator();
            for (String seqNo : allSeqNos) {
                seq = Numbers.toInt((String)seqNo);
                if (seq - newSeqNo >= 2) {
                    int gap = seq - newSeqNo - 1;
                    for (int i = 0; i < gap; ++i) {
                        Clazz clazz = (Clazz)taskIter.next();
                        clazz.setCrn(Strings.repeat((String)"0", (int)(4 - String.valueOf(++newSeqNo).length())) + newSeqNo);
                        if (++allocated >= tasks.size()) break;
                    }
                    if (allocated >= tasks.size()) break;
                }
                newSeqNo = seq;
            }
            while (allocated < tasks.size()) {
                ++allocated;
                Clazz clazz = (Clazz)taskIter.next();
                clazz.setCrn(Strings.repeat((String)"0", (int)(4 - String.valueOf(++newSeqNo).length())) + newSeqNo);
            }
        }
    }
}

