/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.std.model.Student;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzRestriction;
import org.openurp.edu.clazz.model.ClazzRestrictionItem;
import org.openurp.edu.clazz.model.ClazzRestrictionMeta;
import org.openurp.edu.clazz.model.CourseTaker;

public class RestrictionHelper {
    private static RestrictionComparator comparator = new RestrictionComparator();

    public static void autoMatches(Clazz clazz) {
        List<ClazzRestriction> groups = clazz.getEnrollment().getRestrictions();
        Collections.sort(groups, comparator);
        Map cnts = CollectUtils.newHashMap();
        for (CourseTaker taker : clazz.getEnrollment().getCourseTakers()) {
            ClazzRestriction limitGroup = RestrictionHelper.getMatchRestriction(clazz, taker.getStd());
            if (null == limitGroup) continue;
            Integer old = (Integer)cnts.get(limitGroup);
            if (null == old) {
                cnts.put(limitGroup, 1);
                continue;
            }
            cnts.put(limitGroup, old + 1);
        }
    }

    public static ClazzRestriction getMatchRestriction(Clazz clazz, Student student) {
        for (ClazzRestriction group : clazz.getEnrollment().getRestrictions()) {
            boolean groupPass = true;
            for (ClazzRestrictionItem item : group.getItems()) {
                boolean itemPass = true;
                ClazzRestrictionMeta meta = item.getMeta();
                Set values = CollectUtils.newHashSet((Object[])item.getContents().split(","));
                Object value = null;
                if (meta.equals((Object)ClazzRestrictionMeta.Squad)) {
                    value = student.getSquad() == null ? "" : String.valueOf(student.getSquad().getId());
                } else if (meta.equals((Object)ClazzRestrictionMeta.Department)) {
                    value = String.valueOf(student.getDepartment().getId());
                } else if (meta.equals((Object)ClazzRestrictionMeta.Direction)) {
                    value = student.getDirection() == null ? "" : String.valueOf(student.getDirection().getId());
                } else if (meta.equals((Object)ClazzRestrictionMeta.Level)) {
                    value = String.valueOf(student.getLevel().getId());
                } else if (meta.equals((Object)ClazzRestrictionMeta.Gender)) {
                    value = String.valueOf(student.getGender().getId());
                } else if (meta.equals((Object)ClazzRestrictionMeta.Grade)) {
                    value = student.getGrade().getCode();
                } else if (meta.equals((Object)ClazzRestrictionMeta.Major)) {
                    value = String.valueOf(student.getMajor().getId());
                } else if (meta.equals((Object)ClazzRestrictionMeta.StdType)) {
                    value = String.valueOf(student.getStdType().getId());
                } else if (meta.equals((Object)ClazzRestrictionMeta.EduType)) {
                    value = String.valueOf(student.getEduType().getId());
                }
                if (item.isIncluded()) {
                    itemPass = values.isEmpty() || values.contains(value);
                } else {
                    boolean bl = itemPass = !values.isEmpty() && !values.contains(value);
                }
                if (itemPass) continue;
                groupPass = false;
                break;
            }
            if (!groupPass) continue;
            return group;
        }
        return null;
    }

    public static RestrictionComparator getComparator() {
        return comparator;
    }

    private static class RestrictionComparator
    implements Comparator<ClazzRestriction> {
        private static final int MAXPRIORITY = 20000;
        private static final int HIGHPRIORITY = 10000;
        private static final int NORMALPRIORITY = 5000;
        private static final int LOWPRIORITY = 2500;
        private static final int ZEROPRIORITY = 500;
        private List<ClazzRestrictionMeta> restrictionMetas = CollectUtils.newArrayList((Object[])new ClazzRestrictionMeta[]{ClazzRestrictionMeta.Squad, ClazzRestrictionMeta.Direction, ClazzRestrictionMeta.Major, ClazzRestrictionMeta.Department});

        private RestrictionComparator() {
        }

        @Override
        public int compare(ClazzRestriction o1, ClazzRestriction o2) {
            int priorty2;
            int priorty1 = this.getPriority(o1);
            if (priorty1 == (priorty2 = this.getPriority(o2))) {
                return o2.getMaxCount() - o2.getCurCount() - (o1.getMaxCount() - o1.getCurCount());
            }
            return priorty2 - priorty1;
        }

        private int getPriority(ClazzRestriction group) {
            int priority = 0;
            boolean hasMax = false;
            for (ClazzRestrictionItem courseLimitItem : group.getItems()) {
                if (!courseLimitItem.isIncluded()) {
                    if (ClazzRestrictionMeta.Squad.equals((Object)courseLimitItem.getMeta())) {
                        if (hasMax) continue;
                        priority += 10000;
                        continue;
                    }
                    if (ClazzRestrictionMeta.Direction.equals((Object)courseLimitItem.getMeta())) {
                        priority += 5000;
                        continue;
                    }
                    if (ClazzRestrictionMeta.Major.equals((Object)courseLimitItem.getMeta())) {
                        priority += 2500;
                        continue;
                    }
                    if (ClazzRestrictionMeta.Department.equals((Object)courseLimitItem.getMeta())) {
                        priority += 1250;
                        continue;
                    }
                    if (this.restrictionMetas.contains((Object)courseLimitItem.getMeta())) continue;
                    priority += 250;
                    continue;
                }
                if (ClazzRestrictionMeta.Squad.equals((Object)courseLimitItem.getMeta())) {
                    if (hasMax) continue;
                    priority += 20000;
                    continue;
                }
                if (ClazzRestrictionMeta.Direction.equals((Object)courseLimitItem.getMeta())) {
                    priority += 10000;
                    continue;
                }
                if (ClazzRestrictionMeta.Major.equals((Object)courseLimitItem.getMeta())) {
                    priority += 5000;
                    continue;
                }
                if (ClazzRestrictionMeta.Department.equals((Object)courseLimitItem.getMeta())) {
                    priority += 2500;
                    continue;
                }
                if (this.restrictionMetas.contains((Object)courseLimitItem.getMeta())) continue;
                priority += 500;
            }
            return priority;
        }
    }
}

