/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.tuple.Pair;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.MajorDirection;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Squad;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.person.model.Gender;
import org.openurp.code.std.model.StdType;
import org.openurp.edu.clazz.model.ClazzRestriction;
import org.openurp.edu.clazz.model.ClazzRestrictionItem;
import org.openurp.edu.clazz.model.ClazzRestrictionMeta;
import org.openurp.edu.clazz.service.CourseLimitExtractorService;

public class CourseLimitExtractorServiceImpl
extends BaseServiceImpl
implements CourseLimitExtractorService {
    @Override
    public List<EducationLevel> extractEducations(ClazzRestriction restriction) {
        Pair<Boolean, List<EducationLevel>> res = this.xtractEducationLimit(restriction);
        if (((Boolean)res.getLeft()).booleanValue()) {
            return (List)res.getRight();
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public List<Squad> extractSquades(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.Squad.equals((Object)item.getMeta()) || !item.isIncluded()) continue;
            return this.entityDao.get(Squad.class, (Serializable[])Strings.splitToLong((String)item.getContents()));
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public String extractGrade(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.Grade.equals((Object)item.getMeta()) || !item.isIncluded()) continue;
            return item.getContents();
        }
        return null;
    }

    @Override
    public List<StdType> extractStdTypes(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.StdType.equals((Object)item.getMeta()) || !item.isIncluded()) continue;
            return this.entityDao.get(StdType.class, (Serializable[])Strings.splitToInt((String)item.getContents()));
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public List<Major> extractMajors(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.Major.equals(item.getMeta().getId()) || !item.isIncluded()) continue;
            return this.entityDao.get(Major.class, (Serializable[])Strings.splitToLong((String)item.getContents()));
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public List<MajorDirection> extractDirections(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.Direction.equals(item.getMeta().getId()) || !item.isIncluded()) continue;
            return this.entityDao.get(MajorDirection.class, (Serializable[])Strings.splitToLong((String)item.getContents()));
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public List<Department> extractAttendDeparts(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.Department.equals(item.getMeta().getId()) || !item.isIncluded()) continue;
            return this.entityDao.get(Department.class, (Serializable[])Strings.splitToInt((String)item.getContents()));
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public Gender extractGender(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.Gender.equals(item.getMeta().getId()) || !item.isIncluded()) continue;
            return (Gender)((Object)this.entityDao.get(Gender.class, (Serializable[])Strings.splitToInt((String)item.getContents())).get(0));
        }
        return null;
    }

    @Override
    public Pair<Boolean, List<EducationLevel>> xtractEducationLimit(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.Level.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(EducationLevel.class, (Serializable[])Strings.splitToInt((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }

    @Override
    public Pair<Boolean, List<Squad>> xtractSquadLimit(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.Squad.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(Squad.class, (Serializable[])Strings.splitToLong((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }

    @Override
    public Pair<Boolean, List<Department>> xtractAttendDepartLimit(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.Department.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(Department.class, (Serializable[])Strings.splitToInt((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }

    @Override
    public Pair<Boolean, List<MajorDirection>> xtractDirectionLimit(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.Direction.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(MajorDirection.class, (Serializable[])Strings.splitToLong((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }

    @Override
    public Pair<Boolean, List<String>> xtractGradeLimit(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.Gender.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)CollectUtils.newArrayList((Object[])new String[]{item.getContents()}));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }

    @Override
    public Pair<Boolean, List<Major>> xtractMajorLimit(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.Major.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(Major.class, (Serializable[])Strings.splitToLong((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }

    @Override
    public Pair<Boolean, List<StdType>> xtractStdTypeLimit(ClazzRestriction restriction) {
        for (ClazzRestrictionItem item : restriction.getItems()) {
            if (!ClazzRestrictionMeta.StdType.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(StdType.class, (Serializable[])Strings.splitToInt((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }
}

