/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.util;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.bean.comparators.MultiPropertyComparator;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.tuple.Pair;
import org.beangle.commons.text.i18n.TextResource;
import org.beangle.orm.hibernate.udt.WeekDay;
import org.beangle.orm.hibernate.udt.WeekState;
import org.beangle.orm.hibernate.udt.WeekTime;
import org.beangle.orm.hibernate.udt.Weeks;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.edu.model.TimeSetting;
import org.openurp.base.edu.model.WeekTimeBuilder;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.resource.model.Classroom;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzActivity;

public class ScheduleDigestor {
    public static final String singleTeacher = ":teacher1";
    public static final String multiTeacher = ":teacher+";
    public static final String moreThan1Teacher = ":teacher2";
    public static final String day = ":day";
    public static final String units = ":units";
    public static final String weeks = ":weeks";
    public static final String time = ":time";
    public static final String room = ":room";
    public static final String building = ":building";
    public static final String district = ":district";
    public static final String clazz = ":clazz";
    public static final String course = ":course";
    public static final String starton = ":starton";
    public static final String defaultFormat = ":teacher+ :day :units :weeks :room";
    private String delimeter = ",";
    private static Map<Integer, String> weekdayNames = new HashMap<Integer, String>();

    private ScheduleDigestor() {
        for (WeekDay wd : WeekDay.All) {
            weekdayNames.put(wd.getId(), wd.getName().replace("\u661f\u671f", "\u5468"));
        }
    }

    public static ScheduleDigestor getInstance() {
        return new ScheduleDigestor();
    }

    public String digest(TextResource textResource, TimeSetting timeSetting, Clazz clazz) {
        return this.digest(textResource, timeSetting, clazz, defaultFormat);
    }

    public String digest(TextResource textResource, TimeSetting timeSetting, Clazz clazz, String format) {
        return this.digest(textResource, timeSetting, clazz.getSchedule().getActivities(), format);
    }

    public String digest(TextResource textResource, TimeSetting timeSetting, Collection<ClazzActivity> activities) {
        return this.digest(textResource, timeSetting, activities, defaultFormat);
    }

    public String digest(TextResource textResource, TimeSetting timeSetting, Collection<ClazzActivity> activities, String format) {
        if (CollectUtils.isEmpty(activities)) {
            return "";
        }
        if (Strings.isEmpty((CharSequence)format)) {
            format = defaultFormat;
        }
        Clazz clazzx = activities.iterator().next().getClazz();
        Semester semester = clazzx.getSemester();
        Set teachers = CollectUtils.newHashSet();
        boolean hasRoom = Strings.contains((CharSequence)format, (CharSequence)room);
        boolean hasTeacher = Strings.contains((CharSequence)format, (CharSequence)"teacher");
        if (hasTeacher) {
            for (ClazzActivity ca : activities) {
                if (!CollectUtils.isNotEmpty(ca.getTeachers())) continue;
                teachers.addAll(ca.getTeachers());
            }
        }
        List<ClazzActivity> mergedActivities = ScheduleDigestor.merge(semester, activities, hasTeacher, hasRoom);
        boolean addTeacher = false;
        if (hasTeacher) {
            addTeacher = true;
            if (format.indexOf(singleTeacher) != -1 && teachers.size() != 1) {
                addTeacher = false;
            }
            if (format.indexOf(moreThan1Teacher) != -1 && teachers.size() < 2) {
                addTeacher = false;
            }
            if (format.indexOf(multiTeacher) != -1 && teachers.size() == 0) {
                addTeacher = false;
            }
        }
        StringBuffer CourseArrangeBuf = new StringBuffer();
        Collections.sort(mergedActivities, new MultiPropertyComparator("clazz.course.code,time.startOn"));
        for (ClazzActivity activity : mergedActivities) {
            Date firstDay;
            CourseArrangeBuf.append(format);
            int replaceStart = 0;
            replaceStart = CourseArrangeBuf.indexOf(":teacher");
            if (addTeacher) {
                StringBuilder teacherStr = new StringBuilder("");
                for (Teacher teacher : activity.getTeachers()) {
                    teacherStr.append(teacher.getName());
                }
                CourseArrangeBuf.replace(replaceStart, replaceStart + 9, teacherStr.toString());
            } else if (-1 != replaceStart) {
                CourseArrangeBuf.replace(replaceStart, replaceStart + 9, "");
            }
            replaceStart = CourseArrangeBuf.indexOf(day);
            if (-1 != replaceStart) {
                WeekDay weekday = activity.getTime().getWeekday();
                if (null != textResource && textResource.getLocale().getLanguage().equals("en")) {
                    CourseArrangeBuf.replace(replaceStart, replaceStart + day.length(), weekday.getEnName() + ".");
                } else {
                    CourseArrangeBuf.replace(replaceStart, replaceStart + day.length(), weekdayNames.get(weekday.getId()));
                }
            }
            if (-1 != (replaceStart = CourseArrangeBuf.indexOf(units))) {
                Pair<Integer, Integer> rs = timeSetting.getUnitLevel(activity.getTime().getBeginAt(), activity.getTime().getEndAt());
                CourseArrangeBuf.replace(replaceStart, replaceStart + units.length(), String.valueOf(rs.getLeft()) + "-" + String.valueOf(rs.getRight()));
            }
            if (-1 != (replaceStart = CourseArrangeBuf.indexOf(time))) {
                CourseArrangeBuf.replace(replaceStart, replaceStart + time.length(), activity.getTime().getBeginAt().toString() + "-" + activity.getTime().getEndAt().toString());
            }
            if (-1 != (replaceStart = CourseArrangeBuf.indexOf(clazz))) {
                CourseArrangeBuf.replace(replaceStart, replaceStart + clazz.length(), activity.getClazz().getCrn());
            }
            if (-1 != (replaceStart = CourseArrangeBuf.indexOf(course))) {
                CourseArrangeBuf.replace(replaceStart, replaceStart + course.length(), activity.getClazz().getCourse().getName() + "(" + activity.getClazz().getCourse().getCode() + ")");
            }
            if (-1 != (replaceStart = CourseArrangeBuf.indexOf(weeks))) {
                CourseArrangeBuf.replace(replaceStart, replaceStart + weeks.length(), WeekTimeBuilder.digestWeekTime(activity.getTime(), semester) + " ");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("M\u6708dd\u65e5\u8d77");
            replaceStart = CourseArrangeBuf.indexOf(starton);
            if (-1 != replaceStart && null != (firstDay = activity.getClazz().getFirstCourseTime())) {
                CourseArrangeBuf.replace(replaceStart, replaceStart + starton.length(), sdf.format(firstDay));
            }
            if (-1 != (replaceStart = CourseArrangeBuf.indexOf(room))) {
                Classroom room;
                Set<Classroom> rooms = activity.getRooms();
                StringBuilder roomStr = new StringBuilder("");
                Iterator<Classroom> it = rooms.iterator();
                while (it.hasNext()) {
                    Classroom room2 = it.next();
                    roomStr.append(room2.getName());
                    if (!it.hasNext()) continue;
                    roomStr.append(",");
                }
                if (roomStr.length() == 0 && null != activity.getRemark()) {
                    roomStr.append(activity.getRemark());
                }
                CourseArrangeBuf.replace(replaceStart, replaceStart + room.length(), roomStr.toString());
                replaceStart = CourseArrangeBuf.indexOf(building);
                if (-1 != replaceStart) {
                    StringBuilder buildingStr = new StringBuilder("");
                    Iterator<Classroom> iterator = rooms.iterator();
                    while (iterator.hasNext()) {
                        room = iterator.next();
                        if (room.getBuilding() != null) {
                            buildingStr.append(room.getBuilding().getName());
                        }
                        if (!iterator.hasNext()) continue;
                        buildingStr.append(",");
                    }
                    CourseArrangeBuf.replace(replaceStart, replaceStart + building.length(), buildingStr.toString());
                }
                if (-1 != (replaceStart = CourseArrangeBuf.indexOf(district))) {
                    StringBuilder districtStr = new StringBuilder("");
                    Iterator<Classroom> it2 = rooms.iterator();
                    while (it2.hasNext()) {
                        room = it2.next();
                        districtStr.append(room.getCampus().getName());
                        if (!it2.hasNext()) continue;
                        districtStr.append(",");
                    }
                    CourseArrangeBuf.replace(replaceStart, replaceStart + district.length(), districtStr.toString());
                }
            }
            CourseArrangeBuf.append(" ").append(this.delimeter);
        }
        if (CourseArrangeBuf.lastIndexOf(this.delimeter) != -1) {
            CourseArrangeBuf.delete(CourseArrangeBuf.lastIndexOf(this.delimeter), CourseArrangeBuf.length());
        }
        return CourseArrangeBuf.toString();
    }

    private static boolean isSameActivityExcept(ClazzActivity target, ClazzActivity other, boolean teacher, boolean room) {
        if (teacher && !target.getTeachers().equals(other.getTeachers())) {
            return false;
        }
        if (room && !target.getRooms().equals(other.getRooms())) {
            return false;
        }
        return ClazzActivity.timeCanMergerWith(target, other, false, 25);
    }

    public static List<ClazzActivity> merge(Semester semester, Collection<ClazzActivity> activities, boolean hasTeacher, boolean hasRoom) {
        List mergedActivities = CollectUtils.newArrayList();
        List activitiesList = CollectUtils.newArrayList();
        for (ClazzActivity ca : activities) {
            activitiesList.add((ClazzActivity)ca.clone());
        }
        Collections.sort(activitiesList);
        Iterator<ClazzActivity> iterator = activitiesList.iterator();
        while (iterator.hasNext()) {
            ClazzActivity ca;
            ClazzActivity activity = ca = iterator.next();
            if (ca.getTime().getStartYear() != semester.getStartYear()) {
                LocalDate nextYearStart = activity.getTime().getStartOn().toLocalDate();
                LocalDate thisYearStart = WeekTime.getStartOn((int)semester.getStartYear(), (WeekDay)activity.getTime().getWeekday());
                int weeks = Weeks.between((LocalDate)thisYearStart, (LocalDate)nextYearStart);
                activity.getTime().setStartOn(Date.valueOf(thisYearStart));
                activity.getTime().setWeekstate(new WeekState(activity.getTime().getWeekstate().value << weeks));
            }
            boolean merged = false;
            for (ClazzActivity added : mergedActivities) {
                if (!added.getClazz().equals(activity.getClazz()) || !ScheduleDigestor.isSameActivityExcept(added, activity, hasTeacher, hasRoom)) continue;
                if (added.getTime().getBeginAt().ge(activity.getTime().getBeginAt())) {
                    added.getTime().setBeginAt(activity.getTime().getBeginAt());
                }
                if (added.getTime().getEndAt().le(activity.getTime().getEndAt())) {
                    added.getTime().setEndAt(activity.getTime().getEndAt());
                }
                added.getTime().setWeekstate(new WeekState(added.getTime().getWeekstate().value | activity.getTime().getWeekstate().value));
                merged = true;
            }
            if (merged) continue;
            mergedActivities.add(activity);
        }
        return mergedActivities;
    }

    public ScheduleDigestor setDelimeter(String delimeter) {
        this.delimeter = delimeter;
        return this;
    }
}

