/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.tuple.Pair;
import org.beangle.commons.text.i18n.TextResource;
import org.beangle.orm.hibernate.udt.WeekDay;
import org.beangle.orm.hibernate.udt.WeekTime;
import org.beangle.orm.hibernate.udt.WeekTimes;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.edu.model.TimeSetting;
import org.openurp.base.edu.model.WeekTimeBuilder;

public class WeekTimeDigestor {
    public static final String day = ":day";
    public static final String units = ":units";
    public static final String weeks = ":weeks";
    public static final String time = ":time";
    public static final String defaultFormat = ":day :units [:weeks]";
    private String delimeter = ",";

    private WeekTimeDigestor() {
    }

    public static WeekTimeDigestor getInstance() {
        return new WeekTimeDigestor();
    }

    public String digest(TextResource textResource, Semester semester, TimeSetting timeSetting, Collection<WeekTime> times) {
        return this.digest(textResource, semester, timeSetting, times, defaultFormat);
    }

    public String digest(TextResource textResource, Semester semester, TimeSetting timeSetting, Collection<WeekTime> times, String format) {
        if (CollectUtils.isEmpty(times)) {
            return "";
        }
        if (Strings.isEmpty((CharSequence)format)) {
            format = defaultFormat;
        }
        List mergedTimes = CollectUtils.newArrayList();
        List timeList = CollectUtils.newArrayList(times);
        Collections.sort(timeList);
        for (WeekTime weektime : timeList) {
            boolean merged = false;
            for (WeekTime added : mergedTimes) {
                if (!WeekTimes.canMergerWith((WeekTime)added, (WeekTime)weektime)) continue;
                WeekTimes.mergeWith((WeekTime)added, (WeekTime)weektime);
                merged = true;
            }
            if (merged) continue;
            mergedTimes.add(weektime);
        }
        StringBuffer arrangeBuf = new StringBuffer();
        for (WeekTime activity : mergedTimes) {
            arrangeBuf.append(format);
            int replaceStart = arrangeBuf.indexOf(day);
            if (-1 != replaceStart) {
                WeekDay weekday = activity.getWeekday();
                if (null != textResource && textResource.getLocale().getLanguage().equals("en")) {
                    arrangeBuf.replace(replaceStart, replaceStart + day.length(), weekday.getEnName() + ".");
                } else {
                    arrangeBuf.replace(replaceStart, replaceStart + day.length(), weekday.getName());
                }
            }
            if (-1 != (replaceStart = arrangeBuf.indexOf(units))) {
                Pair<Integer, Integer> rs = timeSetting.getUnitLevel(activity.getBeginAt(), activity.getEndAt());
                arrangeBuf.replace(replaceStart, replaceStart + units.length(), String.valueOf(rs.getLeft()) + "-" + String.valueOf(rs.getRight()));
            }
            if (-1 != (replaceStart = arrangeBuf.indexOf(time))) {
                arrangeBuf.replace(replaceStart, replaceStart + time.length(), activity.getBeginAt().toString() + "-" + activity.getEndAt().toString());
            }
            if (-1 != (replaceStart = arrangeBuf.indexOf(weeks))) {
                arrangeBuf.replace(replaceStart, replaceStart + weeks.length(), WeekTimeBuilder.digestWeekTime(activity, semester) + " ");
            }
            arrangeBuf.append(" ").append(this.delimeter);
        }
        if (arrangeBuf.lastIndexOf(this.delimeter) != -1) {
            arrangeBuf.delete(arrangeBuf.lastIndexOf(this.delimeter), arrangeBuf.length());
        }
        return arrangeBuf.toString();
    }

    public WeekTimeDigestor setDelimeter(String delimeter) {
        this.delimeter = delimeter;
        return this;
    }
}

