/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.beangle.orm.hibernate.udt.WeekDay;
import org.beangle.orm.hibernate.udt.WeekTime;
import org.openurp.base.edu.model.Semester;
import org.openurp.edu.exam.model.ExamActivity;
import org.openurp.edu.exam.model.ExamRoom;

public class ExamWeekTimeUtil {
    public static WeekTime getWeekTimeFromActivity(ExamActivity activity) {
        WeekTime unit = WeekTime.of((java.sql.Date)activity.getExamOn());
        unit.setBeginAt(activity.getBeginAt());
        unit.setEndAt(activity.getEndAt());
        return unit;
    }

    public static WeekTime getWeekTimeFromActivity(ExamRoom examRoom) {
        WeekTime unit = WeekTime.of((java.sql.Date)examRoom.getExamOn());
        unit.setBeginAt(examRoom.getBeginAt());
        unit.setEndAt(examRoom.getEndAt());
        return unit;
    }

    public static Integer getWeekDayByDate(Date date) {
        return WeekDay.of((Date)date).getIndex();
    }

    public static int getWeekOfYear(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        if (11 == gc.get(2) && 1 == gc.get(3)) {
            return gc.getActualMaximum(3) + 1;
        }
        return gc.get(3);
    }

    public static int getTeachWeekOfYear(Semester semester, Date nowDate) {
        Calendar start = Calendar.getInstance();
        start.setFirstDayOfWeek(semester.getCalendar().getFirstWeekday().getIndex());
        start.setTime(semester.getBeginOn());
        int weeks = 0;
        while (!start.getTime().after(nowDate)) {
            start.add(3, 1);
            ++weeks;
        }
        return weeks;
    }

    @Deprecated
    public static int getTeachWeekOfYear(Date fromDate, Date nowDate) {
        int week = 0;
        int fromYear = fromDate.getYear() + 1900;
        int nowYear = nowDate.getYear() + 1900;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date firstDay = sdf.parse(nowYear + "-01-01");
            int fromWeeks = ExamWeekTimeUtil.getWeekOfYear(fromDate);
            int nowWeeks = ExamWeekTimeUtil.getWeekOfYear(nowDate);
            int firstDayOfWeek = ExamWeekTimeUtil.getWeekDayByDate(firstDay);
            if (nowYear > fromYear) {
                week = 53 - (fromWeeks - 1) + nowWeeks;
                if (firstDayOfWeek != 7) {
                    --week;
                }
            } else {
                week = nowWeeks - (fromWeeks - 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("date parse error");
        }
        return week;
    }
}

