/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.model.StdGpa;
import org.openurp.edu.grade.course.model.StdSemesterGpa;
import org.openurp.edu.grade.course.model.StdYearGpa;
import org.openurp.edu.grade.course.service.impl.GpaPolicy;

public class DefaultGpaPolicy
implements GpaPolicy {
    private int precision = 2;
    private boolean useArithmeticAvg = false;

    @Override
    public Float calcGa(List<CourseGrade> grades) {
        if (this.useArithmeticAvg) {
            return this.calcArithmeticAvg(grades);
        }
        return this.calcCreditAvg(grades);
    }

    private Float calcCreditAvg(List<CourseGrade> grades) {
        double credits = 0.0;
        double creditGas = 0.0;
        for (CourseGrade grade : grades) {
            if ((Integer)grade.getCourseTakeType().getId() == 5 || null == grade.getGp() || !grade.getCourse().isCalgp()) continue;
            Float score = grade.getScore();
            if (null == score) {
                score = Float.valueOf(0.0f);
            }
            double credit = grade.getCourse().getDefaultCredits();
            credits += credit;
            creditGas += credit * (double)score.floatValue();
        }
        return this.round(Float.valueOf(credits == 0.0 ? 0.0f : new Float(creditGas / credits).floatValue()));
    }

    private Float calcArithmeticAvg(List<CourseGrade> grades) {
        double scoreSum = 0.0;
        int count = 0;
        for (CourseGrade grade : grades) {
            if ((Integer)grade.getCourseTakeType().getId() == 5 || null == grade.getGp() || !grade.getCourse().isCalgp()) continue;
            Float score = grade.getScore();
            if (null == score) {
                score = Float.valueOf(0.0f);
            }
            scoreSum += (double)score.floatValue();
            ++count;
        }
        return this.round(Float.valueOf(scoreSum == 0.0 ? 0.0f : new Float(scoreSum / (double)count).floatValue()));
    }

    @Override
    public Float calcGpa(List<CourseGrade> grades) {
        double credits = 0.0;
        double creditGps = 0.0;
        for (CourseGrade grade : grades) {
            if ((Integer)grade.getCourseTakeType().getId() == 5 || null == grade.getGp() || !grade.getCourse().isCalgp()) continue;
            double credit = grade.getCourse().getDefaultCredits();
            credits += credit;
            creditGps += credit * grade.getGp().doubleValue();
        }
        return this.round(Float.valueOf(credits == 0.0 ? 0.0f : new Float(creditGps / credits).floatValue()));
    }

    @Override
    public Float round(Float score) {
        if (null == score) {
            return null;
        }
        int mutilply = (int)Math.pow(10.0, this.precision);
        if ((double)((score = Float.valueOf(score.floatValue() * (float)mutilply)).floatValue() % 1.0f) >= 0.5) {
            score = Float.valueOf(score.floatValue() + 1.0f);
        }
        score = Float.valueOf(score.floatValue() - score.floatValue() % 1.0f);
        return new Float(score.floatValue() / (float)mutilply);
    }

    @Override
    public StdGpa calc(Student std, List<CourseGrade> grades, boolean statDetail) {
        StdGpa stdGpa = new StdGpa(std);
        if (statDetail) {
            Map gradesMap = CollectUtils.newHashMap();
            for (CourseGrade courseGrade : grades) {
                List semesterGrades = (List)gradesMap.get(courseGrade.getSemester());
                if (null == semesterGrades) {
                    semesterGrades = CollectUtils.newArrayList();
                    gradesMap.put(courseGrade.getSemester(), semesterGrades);
                }
                semesterGrades.add(courseGrade);
            }
            Map yearGradeMap = CollectUtils.newHashMap();
            for (Semester semester : gradesMap.keySet()) {
                StdSemesterGpa stdTermGpa = new StdSemesterGpa();
                stdTermGpa.setSemester(semester);
                stdGpa.add(stdTermGpa);
                List semesterGrades = (List)gradesMap.get(semester);
                List yearGrades = (List)yearGradeMap.get(semester.getSchoolYear());
                if (null == yearGrades) {
                    yearGrades = CollectUtils.newArrayList();
                    yearGradeMap.put(semester.getSchoolYear(), yearGrades);
                }
                yearGrades.addAll(semesterGrades);
                stdTermGpa.setGpa(this.calcGpa(semesterGrades));
                stdTermGpa.setWms(this.calcGa(semesterGrades));
                stdTermGpa.setGradeCount(semesterGrades.size());
                Float[] stats = this.statCredits(semesterGrades);
                stdTermGpa.setTotalCredits(stats[0]);
                stdTermGpa.setCredits(stats[1]);
            }
            for (String year : yearGradeMap.keySet()) {
                StdYearGpa stdYearGpa = new StdYearGpa();
                stdYearGpa.setSchoolYear(year);
                stdGpa.add(stdYearGpa);
                List yearGrades = (List)yearGradeMap.get(year);
                stdYearGpa.setGpa(this.calcGpa(yearGrades));
                stdYearGpa.setWms(this.calcGa(yearGrades));
                stdYearGpa.setGradeCount(yearGrades.size());
                Float[] stats = this.statCredits(yearGrades);
                stdYearGpa.setTotalCredits(stats[0]);
                stdYearGpa.setCredits(stats[1]);
            }
        }
        stdGpa.setGpa(this.calcGpa(grades));
        stdGpa.setWms(this.calcGa(grades));
        Map courseMap = CollectUtils.newHashMap();
        for (CourseGrade courseGrade : grades) {
            CourseGrade exist = (CourseGrade)courseMap.get(courseGrade.getCourse());
            if (null != exist && exist.isPassed()) continue;
            courseMap.put(courseGrade.getCourse(), courseGrade);
        }
        stdGpa.setGradeCount(courseMap.size());
        Float[] totalStats = this.statCredits(courseMap.values());
        stdGpa.setTotalCredits(totalStats[0]);
        stdGpa.setCredits(totalStats[1]);
        Date date = new Date();
        stdGpa.setUpdatedAt(date);
        return stdGpa;
    }

    private Float[] statCredits(Collection<CourseGrade> grades) {
        Float credits = Float.valueOf(0.0f);
        Float all = Float.valueOf(0.0f);
        for (CourseGrade grade : grades) {
            if (grade.isPassed()) {
                credits = Float.valueOf(credits.floatValue() + grade.getCourse().getDefaultCredits());
            }
            all = Float.valueOf(all.floatValue() + grade.getCourse().getDefaultCredits());
        }
        return new Float[]{all, credits};
    }

    @Override
    public final int getPrecision() {
        return this.precision;
    }

    public final void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isUseArithmeticAvg() {
        return this.useArithmeticAvg;
    }

    public void setUseArithmeticAvg(boolean useArithmeticAvg) {
        this.useArithmeticAvg = useArithmeticAvg;
    }
}

