/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.beangle.commons.bean.comparators.PropertyComparator;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.Operation;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.entity.metadata.Model;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.functor.Predicate;
import org.openurp.base.edu.model.Project;
import org.openurp.code.edu.model.GradeType;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.grade.Grade;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.model.CourseGradeSetting;
import org.openurp.edu.grade.course.model.CourseGradeState;
import org.openurp.edu.grade.course.model.ExamGrade;
import org.openurp.edu.grade.course.model.ExamGradeState;
import org.openurp.edu.grade.course.model.GaGrade;
import org.openurp.edu.grade.course.model.GaGradeState;
import org.openurp.edu.grade.course.model.GradeState;
import org.openurp.edu.grade.course.service.CourseGradeCalculator;
import org.openurp.edu.grade.course.service.CourseGradePublishStack;
import org.openurp.edu.grade.course.service.CourseGradeService;
import org.openurp.edu.grade.course.service.CourseGradeSettings;
import org.openurp.edu.grade.course.service.GradeCourseTypeProvider;
import org.openurp.edu.grade.course.service.ScoreConverter;

public class CourseGradeServiceImpl
extends BaseServiceImpl
implements CourseGradeService {
    protected CourseGradeCalculator calculator;
    protected GradeCourseTypeProvider gradeCourseTypeProvider;
    protected CourseGradePublishStack publishStack;
    protected CourseGradeSettings settings;

    private List<CourseGrade> getGrades(Clazz clazz) {
        OqlBuilder query = OqlBuilder.from(CourseGrade.class, (String)"courseGrade");
        query.where("courseGrade.clazz = :clazz", (Object)clazz);
        return this.entityDao.search((QueryBuilder)query);
    }

    @Override
    public CourseGradeState getState(Clazz clazz) {
        List list = this.entityDao.get(CourseGradeState.class, "clazz", new Object[]{clazz});
        if (list.isEmpty()) {
            return null;
        }
        return (CourseGradeState)list.get(0);
    }

    @Override
    public List<GradeType> getPublishableGradeTypes(Project project) {
        List gradeTypes = this.entityDao.getAll(GradeType.class);
        CollectUtils.filter((Collection)gradeTypes, (Predicate)new Predicate<GradeType>(){

            public Boolean apply(GradeType input) {
                return input.isGa() || ((Integer)input.getId()).equals(GradeType.FINAL_ID);
            }
        });
        Collections.sort(gradeTypes, new PropertyComparator("code"));
        return gradeTypes;
    }

    @Override
    public void publish(String clazzIdSeq, GradeType[] gradeTypes, boolean isPublished) {
        List clazzes = this.entityDao.get(Clazz.class, (Serializable[])Strings.transformToLong((String[])clazzIdSeq.split(",")));
        if (CollectUtils.isNotEmpty((Collection)clazzes)) {
            for (Clazz clazz : clazzes) {
                this.updateState(clazz, gradeTypes, isPublished ? 2 : 0);
            }
        }
    }

    @Override
    public void recalculate(CourseGradeState gradeState) {
        if (null == gradeState) {
            return;
        }
        List published = CollectUtils.newArrayList();
        for (ExamGradeState examGradeState : gradeState.getExamStates()) {
            if (examGradeState.getStatus() != 2) continue;
            published.add(examGradeState.getGradeType());
        }
        for (GaGradeState gaGradeState : gradeState.getGaStates()) {
            if (gaGradeState.getStatus() != 2) continue;
            published.add(gaGradeState.getGradeType());
        }
        List<CourseGrade> grades = this.getGrades(gradeState.getClazz());
        for (CourseGrade grade : grades) {
            GradeType gradeType;
            if (((Integer)grade.getCourseTakeType().getId()).equals(5)) continue;
            this.updateGradeState(grade, gradeState, grade.getProject());
            for (GaGradeState gaGradeState : gradeState.getGaStates()) {
                gradeType = gaGradeState.getGradeType();
                this.updateGradeState(grade.getGaGrade(gradeType), gaGradeState, grade.getProject());
            }
            for (ExamGradeState examGradeState : gradeState.getExamStates()) {
                gradeType = examGradeState.getGradeType();
                ExamGrade examGrade = grade.getExamGrade(gradeType);
                if (null == examGrade) continue;
                examGrade.setWeight(examGradeState.getWeight());
                this.updateGradeState(grade.getExamGrade(gradeType), examGradeState, grade.getProject());
            }
            grade.getExamGrades().removeIf(x -> gradeState.getState(x.getGradeType()) == null);
            this.calculator.calcAll(grade, gradeState);
        }
        this.entityDao.saveOrUpdate(grades);
        if (!published.isEmpty()) {
            this.publish(((Long)gradeState.getClazz().getId()).toString(), published.toArray(new GradeType[published.size()]), true);
        }
    }

    @Override
    public void remove(Clazz clazz, GradeType gradeType) {
        CourseGradeState state = this.getState(clazz);
        List courseGrades = this.entityDao.get(CourseGrade.class, "clazz", new Object[]{clazz});
        CourseGradeSetting gradeSetting = this.settings.getSetting(clazz.getProject());
        List save = CollectUtils.newArrayList();
        List remove = CollectUtils.newArrayList();
        Set gts = CollectUtils.newHashSet((Object[])new GradeType[]{gradeType});
        if (GradeType.GA_ID.equals(gradeType.getId())) {
            gts.addAll(gradeSetting.getGaElementTypes());
        } else if (GradeType.MAKEUP_GA_ID.equals(gradeType.getId())) {
            gts.add(new GradeType(GradeType.MAKEUP_ID));
        } else if (GradeType.DELAY_GA_ID.equals(gradeType.getId())) {
            gts.add(new GradeType(GradeType.DELAY_ID));
        }
        for (CourseGrade courseGrade : courseGrades) {
            if (((Integer)courseGrade.getCourseTakeType().getId()).equals(5)) {
                courseGrade.setClazz(null);
                courseGrade.setCrn("--");
                save.add(courseGrade);
                continue;
            }
            if (GradeType.FINAL_ID.equals(gradeType.getId())) {
                if (0 != courseGrade.getStatus()) continue;
                remove.add(courseGrade);
                continue;
            }
            if (this.removeGrade(courseGrade, gts, state)) {
                remove.add(courseGrade);
                continue;
            }
            save.add(courseGrade);
        }
        if (null != state) {
            if (GradeType.FINAL_ID.equals(gradeType.getId())) {
                state.setStatus(0);
                state.getExamStates().clear();
                state.getGaStates().clear();
            } else {
                for (GradeType gt : gts) {
                    if (gt.isGa()) {
                        GaGradeState ggs = (GaGradeState)state.getState(gt);
                        state.getGaStates().remove(ggs);
                        continue;
                    }
                    ExamGradeState egs = (ExamGradeState)state.getState(gt);
                    state.getExamStates().remove(egs);
                }
            }
        }
        if (state.getExamStates().isEmpty() && state.getGaStates().isEmpty()) {
            remove.add(state);
        } else {
            save.add(state);
        }
        this.entityDao.execute(Operation.saveOrUpdate((Collection)save).remove((Collection)remove));
    }

    private boolean removeGrade(CourseGrade courseGrade, Collection<GradeType> gradeTypes, CourseGradeState state) {
        for (GradeType gradeType : gradeTypes) {
            if (gradeType.isGa()) {
                GaGrade ga = courseGrade.getGaGrade(gradeType);
                if (null == ga || 0 != ga.getStatus()) continue;
                courseGrade.getGaGrades().remove(ga);
                continue;
            }
            ExamGrade exam = courseGrade.getExamGrade(gradeType);
            if (null == exam || 0 != exam.getStatus()) continue;
            courseGrade.getExamGrades().remove(exam);
        }
        if (CollectUtils.isNotEmpty(courseGrade.getGaGrades()) || CollectUtils.isNotEmpty(courseGrade.getExamGrades())) {
            this.calculator.calcAll(courseGrade, state);
            return false;
        }
        return true;
    }

    public void setCalculator(CourseGradeCalculator calculator) {
        this.calculator = calculator;
    }

    public void setCourseGradePublishStack(CourseGradePublishStack courseGradePublishStack) {
        this.publishStack = courseGradePublishStack;
    }

    public void setGradeCourseTypeProvider(GradeCourseTypeProvider gradeCourseTypeProvider) {
        this.gradeCourseTypeProvider = gradeCourseTypeProvider;
    }

    private void updateGradeState(Grade grade, GradeState state, Project project) {
        if (null != grade && null != state) {
            if (!Objects.equals((Object)((Object)grade.getGradingMode()), (Object)((Object)state.getGradingMode()))) {
                grade.setGradingMode(state.getGradingMode());
                ScoreConverter converter = this.calculator.getGradeRateService().getConverter(project, state.getGradingMode());
                grade.setScoreText(converter.convert(grade.getScore()));
            }
            grade.setStatus(state.getStatus());
        }
    }

    private void updateState(Clazz clazz, GradeType[] gradeTypes, int status) {
        List courseGradeStates = this.entityDao.get(CourseGradeState.class, "clazz", new Object[]{clazz});
        CourseGradeState gradeState = null;
        for (GradeType gradeType : gradeTypes) {
            gradeState = courseGradeStates.isEmpty() ? (CourseGradeState)Model.newInstance(CourseGradeState.class) : (CourseGradeState)courseGradeStates.get(0);
            if (((Integer)gradeType.getId()).equals(GradeType.FINAL_ID)) {
                gradeState.setStatus(status);
                continue;
            }
            gradeState.updateStatus(gradeType, status);
        }
        List grades = this.entityDao.get(CourseGrade.class, "clazz", new Object[]{clazz});
        List toBeSaved = CollectUtils.newArrayList();
        Set published = CollectUtils.newHashSet();
        for (CourseGrade grade : grades) {
            if (((Integer)grade.getCourseTakeType().getId()).equals(5)) continue;
            for (GradeType gradeType : gradeTypes) {
                boolean updated = false;
                if (((Integer)gradeType.getId()).equals(GradeType.FINAL_ID)) {
                    grade.setStatus(status);
                    updated = true;
                } else {
                    Grade examGrade = grade.getGrade(gradeType);
                    if (null != examGrade) {
                        examGrade.setStatus(status);
                        updated = true;
                    }
                }
                if (!updated) continue;
                published.add(grade);
            }
        }
        if (status == 2) {
            toBeSaved.addAll(this.publishStack.onPublish(published, gradeState, gradeTypes));
        }
        toBeSaved.addAll(Operation.saveOrUpdate((Object[])new Object[]{clazz, gradeState}).saveOrUpdate((Collection)published).build());
        this.entityDao.execute(toBeSaved.toArray(new Operation[toBeSaved.size()]));
    }

    public void setSettings(CourseGradeSettings settings) {
        this.settings = settings;
    }
}

