/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Course;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.plan.service.StdGrade;

public class StdGradeImpl
implements StdGrade {
    private Map<Course, List<CourseGrade>> gradeMap = new HashMap<Course, List<CourseGrade>>();
    private Set<Course> usedCourses = new HashSet<Course>();
    private Set<Course> noGradeCourses = new HashSet<Course>();

    public StdGradeImpl(List<CourseGrade> courseGrades) {
        List<CourseGrade> gradelist;
        for (CourseGrade courseGrade : courseGrades) {
            gradelist = this.gradeMap.get(courseGrade.getCourse());
            if (null == gradelist) {
                gradelist = new ArrayList<CourseGrade>();
                this.gradeMap.put(courseGrade.getCourse(), gradelist);
            }
            gradelist.add(courseGrade);
        }
        for (Course course : this.gradeMap.keySet()) {
            gradelist = this.gradeMap.get(course);
            Collections.sort(gradelist);
        }
    }

    @Override
    public List<CourseGrade> getGrades(Course course) {
        if (this.noGradeCourses.contains(course)) {
            return Collections.emptyList();
        }
        List<CourseGrade> courseGrades = this.gradeMap.get(course);
        if (null == courseGrades) {
            courseGrades = new ArrayList<CourseGrade>();
        }
        return courseGrades;
    }

    @Override
    public List<CourseGrade> useGrades(Course course) {
        if (this.noGradeCourses.contains(course)) {
            return Collections.emptyList();
        }
        List<CourseGrade> courseGrades = this.gradeMap.get(course);
        if (null == courseGrades) {
            courseGrades = new ArrayList<CourseGrade>();
        }
        this.usedCourses.add(course);
        return courseGrades;
    }

    @Override
    public Collection<Course> getRestCourses() {
        return CollectUtils.subtract(this.gradeMap.keySet(), this.usedCourses);
    }

    @Override
    public List<CourseGrade> getGrades() {
        ArrayList<CourseGrade> grades = new ArrayList<CourseGrade>();
        for (Course course : this.gradeMap.keySet()) {
            grades.addAll((Collection<CourseGrade>)this.gradeMap.get(course));
        }
        return grades;
    }

    @Override
    public void addNoGradeCourse(Course course) {
        this.noGradeCourses.add(course);
    }

    @Override
    public Map<Long, Boolean> getCoursePassedMap() {
        Map passedMap = CollectUtils.newHashMap();
        for (Course course : this.gradeMap.keySet()) {
            List<CourseGrade> grades = this.gradeMap.get(course);
            if (grades.isEmpty()) continue;
            CourseGrade g = grades.get(0);
            passedMap.put((Long)course.getId(), g.isPassed());
        }
        return passedMap;
    }
}

