/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.observers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.plan.adapters.GroupResultAdapter;
import org.openurp.edu.grade.plan.model.AuditCourseResult;
import org.openurp.edu.grade.plan.model.AuditGroupResult;
import org.openurp.edu.grade.plan.model.AuditPlanResult;
import org.openurp.edu.grade.plan.service.AuditPlanContext;
import org.openurp.edu.grade.plan.service.observers.PlanAuditObserver;

public class PlanAuditPersistObserver
extends BaseServiceImpl
implements PlanAuditObserver {
    @Override
    public void notifyStart() {
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean notifyBegin(AuditPlanContext context, int index) {
        return true;
    }

    private AuditPlanResult getResult(Student std) {
        OqlBuilder query = OqlBuilder.from(AuditPlanResult.class, (String)"planResult");
        query.where("planResult.std = :std", (Object)std);
        List results = this.entityDao.search((QueryBuilder)query);
        if (results.size() > 0) {
            return (AuditPlanResult)((Object)results.get(0));
        }
        return null;
    }

    @Override
    public void notifyEnd(AuditPlanContext context, int index) {
        AuditPlanResult newResult = context.getResult();
        AuditPlanResult existedResult = this.getResult(context.getStd());
        if (null != existedResult) {
            existedResult.setRemark(newResult.getRemark());
            existedResult.setUpdatedAt(new Date());
            existedResult.setRequiredCredits(newResult.getRequiredCredits());
            existedResult.setPassedCredits(newResult.getPassedCredits());
            StringBuilder updates = new StringBuilder();
            this.mergeGroupResult(existedResult, new GroupResultAdapter(existedResult), new GroupResultAdapter(newResult), updates);
            existedResult.setPassed(newResult.isPassed());
            if (updates.length() > 0) {
                updates.deleteCharAt(updates.length() - 1);
            }
            existedResult.setUpdates(updates.toString());
        } else {
            existedResult = newResult;
        }
        try {
            this.entityDao.saveOrUpdate(new Object[]{existedResult});
        }
        catch (Exception e) {
            this.logger.error("save {} plan audit result error.", (Object)context.getStd().getCode());
        }
        context.setResult(existedResult);
    }

    private void mergeGroupResult(AuditPlanResult existedResult, AuditGroupResult target, AuditGroupResult source, StringBuilder updates) {
        float delta = source.getAuditStat().getPassedCredits() - target.getAuditStat().getPassedCredits();
        if (Float.compare(delta, 0.0f) != 0) {
            updates.append(source.getName());
            if (delta > 0.0f) {
                updates.append('+').append(delta);
            } else {
                updates.append(delta);
            }
            updates.append(';');
        }
        target.setAuditStat(source.getAuditStat());
        target.setPassed(source.isPassed());
        target.setIndexno(source.getIndexno());
        Map targetGroupResults = CollectUtils.newHashMap();
        Map sourceGroupResults = CollectUtils.newHashMap();
        for (AuditGroupResult result : target.getChildren()) {
            targetGroupResults.put(result.getName(), result);
        }
        for (AuditGroupResult result : source.getChildren()) {
            sourceGroupResults.put(result.getName(), result);
        }
        Map targetCourseResults = CollectUtils.newHashMap();
        Map sourceCourseResults = CollectUtils.newHashMap();
        for (AuditCourseResult auditCourseResult : target.getCourseResults()) {
            targetCourseResults.put(auditCourseResult.getCourse(), auditCourseResult);
        }
        for (AuditCourseResult auditCourseResult : source.getCourseResults()) {
            sourceCourseResults.put(auditCourseResult.getCourse(), auditCourseResult);
        }
        Set removed = CollectUtils.subtract(targetGroupResults.keySet(), sourceGroupResults.keySet());
        for (Object groupName : removed) {
            AuditGroupResult gg = (AuditGroupResult)((Object)targetGroupResults.get(groupName));
            gg.detach();
            target.removeChild(gg);
        }
        Set set = CollectUtils.subtract(sourceGroupResults.keySet(), targetGroupResults.keySet());
        for (Object groupName : set) {
            AuditGroupResult groupResult = (AuditGroupResult)((Object)sourceGroupResults.get(groupName));
            target.addChild(groupResult);
            groupResult.attachTo(existedResult);
        }
        Set common = CollectUtils.intersection(sourceGroupResults.keySet(), targetGroupResults.keySet());
        for (Object groupName : common) {
            this.mergeGroupResult(existedResult, (AuditGroupResult)((Object)targetGroupResults.get(groupName)), (AuditGroupResult)((Object)sourceGroupResults.get(groupName)), updates);
        }
        Set removedCourses = CollectUtils.subtract(targetCourseResults.keySet(), sourceCourseResults.keySet());
        for (Object course : removedCourses) {
            AuditCourseResult courseResult = (AuditCourseResult)((Object)targetCourseResults.get(course));
            target.getCourseResults().remove((Object)courseResult);
        }
        Set addedCourses = CollectUtils.subtract(sourceCourseResults.keySet(), targetCourseResults.keySet());
        for (Course course : addedCourses) {
            AuditCourseResult courseResult = (AuditCourseResult)((Object)sourceCourseResults.get(course));
            courseResult.getGroupResult().getCourseResults().remove((Object)courseResult);
            courseResult.setGroupResult(target);
            target.getCourseResults().add(courseResult);
        }
        Set commonCourses = CollectUtils.intersection(sourceCourseResults.keySet(), targetCourseResults.keySet());
        for (Course course : commonCourses) {
            AuditCourseResult targetCourseResult = (AuditCourseResult)((Object)targetCourseResults.get(course));
            AuditCourseResult sourceCourseResult = (AuditCourseResult)((Object)sourceCourseResults.get(course));
            targetCourseResult.setPassed(sourceCourseResult.isPassed());
            targetCourseResult.setScores(sourceCourseResult.getScores());
            targetCourseResult.setCompulsory(sourceCourseResult.isCompulsory());
            targetCourseResult.setRemark(sourceCourseResult.getRemark());
        }
    }
}

