/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.transcript.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.service.CourseGradeProvider;
import org.openurp.edu.grade.course.service.impl.GpaPolicy;
import org.openurp.edu.grade.course.service.impl.GradeFilter;
import org.openurp.edu.grade.course.service.impl.GradeFilterRegistry;
import org.openurp.edu.grade.transcript.service.TranscriptDataProvider;

public class TranscriptGpaProvider
implements TranscriptDataProvider {
    private CourseGradeProvider courseGradeProvider;
    private GpaPolicy gpaPolicy;
    private GradeFilterRegistry gradeFilterRegistry;

    @Override
    public String getDataName() {
        return "gpas";
    }

    @Override
    public Object getDatas(List<Student> stds, Map<String, String> options) {
        List<GradeFilter> matched = this.getFilters(options);
        Map datas = CollectUtils.newHashMap();
        Map<Student, List<CourseGrade>> gradeMap = this.courseGradeProvider.getPublished(stds, new Semester[0]);
        for (Student std : stds) {
            List<CourseGrade> grades = gradeMap.get(std);
            for (GradeFilter filter : matched) {
                grades = filter.filter(grades);
            }
            datas.put(std, this.gpaPolicy.calc(std, grades, true));
        }
        return datas;
    }

    public void setCourseGradeProvider(CourseGradeProvider courseGradeProvider) {
        this.courseGradeProvider = courseGradeProvider;
    }

    public void setGradeFilterRegistry(GradeFilterRegistry gradeFilterRegistry) {
        this.gradeFilterRegistry = gradeFilterRegistry;
    }

    protected List<GradeFilter> getFilters(Map<String, String> options) {
        if (null == options || options.isEmpty()) {
            return Collections.emptyList();
        }
        return this.gradeFilterRegistry.getFilters(options.get("gpa.filters"));
    }

    public void setGpaPolicy(GpaPolicy gpaPolicy) {
        this.gpaPolicy = gpaPolicy;
    }
}

