/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.app.service.impl;

import java.io.Serializable;
import java.util.List;
import org.beangle.commons.collection.Order;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.edu.program.app.dao.ExecutivePlanCourseGroupModifyApplyDao;
import org.openurp.edu.program.app.model.ExecutiveCourseGroupModify;
import org.openurp.edu.program.app.model.ExecutiveCourseGroupModifyDetailAfter;
import org.openurp.edu.program.app.model.ExecutiveCourseGroupModifyDetailBefore;
import org.openurp.edu.program.app.model.ExecutivePlanCourseModify;
import org.openurp.edu.program.app.model.FakeCourseGroup;
import org.openurp.edu.program.app.service.ExecutivePlanCourseGroupModifyApplyService;
import org.openurp.edu.program.model.ExecutiveCourseGroup;
import org.openurp.edu.program.model.ExecutivePlan;

public class ExecutivePlanCourseGroupModifyApplyServiceImpl
extends BaseServiceImpl
implements ExecutivePlanCourseGroupModifyApplyService {
    private ExecutivePlanCourseGroupModifyApplyDao executePlanCourseGroupModifyApplyDao;

    @Override
    public List<ExecutiveCourseGroupModify> appliesOfPlan(Long planId) {
        OqlBuilder oql = OqlBuilder.from(ExecutiveCourseGroupModify.class, (String)"applyBean");
        oql.where("applyBean.executePlan.id =:planId", (Object)planId);
        return this.entityDao.search((QueryBuilder)oql);
    }

    @Override
    public List<ExecutiveCourseGroupModify> myApplies(Long planId, Long userId) {
        OqlBuilder oql = OqlBuilder.from(ExecutiveCourseGroupModify.class, (String)"apply");
        oql.where("apply.executePlan.id =:planId", (Object)planId).where("apply.proposer.id =:userId", (Object)userId).orderBy("apply.flag").orderBy(Order.desc((String)"apply.applyDate"));
        return this.entityDao.search((QueryBuilder)oql);
    }

    @Override
    public List<ExecutiveCourseGroup> myReadyModifyApply(Long planId, Long userId) {
        OqlBuilder query = OqlBuilder.from((String)(ExecutiveCourseGroupModify.class.getName() + " apply, " + ExecutivePlan.class.getName() + " plan"));
        query.select("select cgroup").where("apply.executePlan.id = plan.id").join("plan.groups", "cgroup").where("apply.executePlan.id = :planId", (Object)planId).where("apply.proposer.id = :userId", (Object)userId).where("apply.flag = :flag", (Object)ExecutivePlanCourseModify.INITREQUEST).where("exists(select state.id from " + ExecutiveCourseGroupModifyDetailBefore.class.getName() + " state where state.apply.id = apply.id and state.courseType=cgroup.courseType)");
        return this.entityDao.search((QueryBuilder)query);
    }

    @Override
    public List<ExecutiveCourseGroupModify> myReadyAddApplies(Long planId, Long userId) {
        OqlBuilder oql = OqlBuilder.from(ExecutiveCourseGroupModify.class, (String)"apply");
        oql.where("apply.executePlan.id =:planId", (Object)planId).where("apply.proposer.id =:userId", (Object)userId).where("apply.flag = :flag", (Object)ExecutivePlanCourseModify.INITREQUEST).where("apply.requisitionType = :requisitionType", (Object)ExecutivePlanCourseModify.ADD).orderBy(Order.desc((String)"apply.applyDate"));
        return this.entityDao.search((QueryBuilder)oql);
    }

    @Override
    public void saveModifyApply(ExecutiveCourseGroupModify modifyBean, Long courseGroupId, ExecutiveCourseGroupModifyDetailAfter after) {
        ExecutiveCourseGroupModifyDetailBefore before = null;
        if (courseGroupId != null) {
            ExecutiveCourseGroup courseGroup = (ExecutiveCourseGroup)this.entityDao.get(ExecutiveCourseGroup.class, (Serializable)courseGroupId);
            before = new ExecutiveCourseGroupModifyDetailBefore();
            before.setApply(modifyBean);
            before.setSubCount(courseGroup.getSubCount());
            before.setCourseType(courseGroup.getCourseType());
            before.setCredits(courseGroup.getCredits());
            before.setParent(new FakeCourseGroup((ExecutiveCourseGroup)courseGroup.getParent()));
            before.setRemark(courseGroup.getRemark());
            before.setTermCredits(courseGroup.getTermCredits());
        }
        this.executePlanCourseGroupModifyApplyDao.saveModifyApply(modifyBean, before, after);
    }

    public void setExecutivePlanCourseGroupModifyApplyDao(ExecutivePlanCourseGroupModifyApplyDao executePlanCourseGroupModifyApplyDao) {
        this.executePlanCourseGroupModifyApplyDao = executePlanCourseGroupModifyApplyDao;
    }
}

