/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.service;

import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.MajorDirection;
import org.openurp.base.std.model.Squad;
import org.openurp.code.std.model.StdType;
import org.openurp.edu.program.model.ExecutivePlan;

public class ExecutivePlanQueryBuilder {
    private ExecutivePlanQueryBuilder() {
    }

    public static OqlBuilder<ExecutivePlan> build(Squad squad) {
        OqlBuilder query = OqlBuilder.from(ExecutivePlan.class, (String)"plan");
        query.where("plan.program.grade = :grade", (Object)squad.getGrade()).where(":stdType in elements(plan.program.stdTypes)", (Object)squad.getStdType()).where("plan.program.major = :major", (Object)squad.getMajor());
        if (null == squad.getDirection()) {
            query.where("plan.program.direction is null");
        } else {
            query.where("plan.program.direction =:direction", (Object)squad.getDirection());
        }
        return query;
    }

    public static OqlBuilder<ExecutivePlan> build(String grade, StdType stdType, Major major, MajorDirection direction) {
        OqlBuilder query = OqlBuilder.from(ExecutivePlan.class, (String)"plan");
        query.where("plan.program.grade = :grade", (Object)grade).where("plan.program.major = :major", (Object)major);
        if (null != stdType) {
            query.where(":stdTypes in elements(plan.program.stdTypes)", (Object)stdType);
        }
        if (null != direction) {
            query.where("plan.program.direction =:direction", (Object)direction);
        }
        return query;
    }
}

