/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.collection.Order;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Student;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.ExecutivePlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.model.StdProgramBinding;
import org.openurp.edu.program.plan.service.CoursePlanProvider;

public class CoursePlanProviderImpl
extends BaseServiceImpl
implements CoursePlanProvider {
    private Program getProgram(Student std) {
        OqlBuilder bq = OqlBuilder.from(StdProgramBinding.class, (String)"binding");
        bq.where("binding.std=:std", (Object)std);
        List bindings = this.entityDao.search((QueryBuilder)bq);
        if (bindings.isEmpty()) {
            if (std.getState().getMajor() == null) {
                return null;
            }
            OqlBuilder query = OqlBuilder.from(Program.class, (String)"program");
            query.where("program.grade=:grade", (Object)std.getGrade());
            query.where("program.level=:level", (Object)std.getLevel());
            query.where("program.major=:major", (Object)std.getState().getMajor());
            ArrayList<Department> departs = new ArrayList<Department>();
            departs.add(std.getDepartment());
            if (null != std.getDepartment().getParent()) {
                departs.add(std.getDepartment().getParent());
            }
            query.where("program.department in(:departments)", departs);
            if (std.getState().getDirection() == null) {
                query.where("program.direction is null");
            } else {
                query.where("program.direction is null or program.direction=:direction", (Object)std.getState().getDirection());
            }
            List programs = this.entityDao.search((QueryBuilder)query);
            return programs.isEmpty() ? null : (Program)programs.get(0);
        }
        return ((StdProgramBinding)((Object)bindings.get(0))).getProgram();
    }

    @Override
    public ExecutivePlan getExecutivePlan(Student student) {
        ArrayList<ExecutivePlan> suitables;
        block6: {
            List plans;
            Program program;
            block5: {
                program = this.getProgram(student);
                if (null == program) {
                    return null;
                }
                OqlBuilder query = OqlBuilder.from(ExecutivePlan.class, (String)"plan");
                query.where("plan.program=:program", (Object)program);
                plans = this.entityDao.search((QueryBuilder)query);
                if (plans.isEmpty()) {
                    return null;
                }
                suitables = new ArrayList<ExecutivePlan>();
                if (null != student.getState().getDirection()) break block5;
                for (ExecutivePlan plan : plans) {
                    if (!program.getStdTypes().isEmpty() && !program.getStdTypes().contains((Object)student.getStdType())) continue;
                    suitables.add(plan);
                }
                break block6;
            }
            for (ExecutivePlan plan : plans) {
                if (plan.getProgram().getDirection() == null || !program.getDirection().equals((Object)student.getState().getDirection()) || !program.getStdTypes().isEmpty() && !program.getStdTypes().contains((Object)student.getStdType())) continue;
                suitables.add(plan);
            }
            if (!suitables.isEmpty()) break block6;
            for (ExecutivePlan plan : plans) {
                if (program.getDirection() != null || !program.getStdTypes().isEmpty() && !program.getStdTypes().contains((Object)student.getStdType())) continue;
                suitables.add(plan);
            }
        }
        return suitables.isEmpty() ? null : (ExecutivePlan)suitables.get(0);
    }

    @Override
    public Map<Student, CoursePlan> getCoursePlans(Collection<Student> students) {
        Map result = CollectUtils.newHashMap();
        for (Student student : students) {
            CoursePlan plan = this.getCoursePlan(student);
            if (null == plan) continue;
            result.put(student, plan);
        }
        return result;
    }

    @Override
    public CoursePlan getCoursePlan(Student student) {
        return this.getExecutivePlan(student);
    }

    @Override
    public List<PlanCourse> getPlanCourses(Student student) {
        CoursePlan plan = this.getCoursePlan(student);
        if (null == plan) {
            return CollectUtils.newArrayList();
        }
        Set planCourses = CollectUtils.newHashSet();
        this.addPlanCourse(plan.getGroups(), planCourses);
        return CollectUtils.newArrayList((Collection)planCourses);
    }

    private void addPlanCourse(List<CourseGroup> courseGroups, Set<PlanCourse> planCourses) {
        if (CollectionUtils.isEmpty(courseGroups)) {
            return;
        }
        for (CourseGroup courseGroup : courseGroups) {
            planCourses.addAll(courseGroup.getPlanCourses());
            this.addPlanCourse(courseGroup.getChildren(), planCourses);
        }
    }

    @Override
    public List<Semester> getSemesterByPlanCourse(PlanCourse planCourse) {
        Date beginOn = planCourse.getGroup().getPlan().getBeginOn();
        Date endOn = planCourse.getGroup().getPlan().getEndOn();
        OqlBuilder builder = OqlBuilder.from(Semester.class, (String)"semester");
        builder.where("semester.beginOn <= :endOn", (Object)endOn);
        builder.where("semester.endOn >= :beginOn", (Object)beginOn);
        builder.orderBy(Order.parse((String)"semester.beginOn"));
        List semestersByInterval = this.entityDao.search((QueryBuilder)builder);
        List<Integer> terms = planCourse.getTerms().getTermList();
        List semestersByResult = CollectUtils.newArrayList();
        for (Integer term : terms) {
            semestersByResult.add((Semester)semestersByInterval.get(term - 1));
        }
        return semestersByResult;
    }
}

