/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.util;

import java.io.Serializable;
import java.text.MessageFormat;
import org.beangle.commons.dao.EntityDao;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.MajorDirection;
import org.openurp.base.std.model.Grade;
import org.openurp.base.std.model.Student;
import org.openurp.edu.program.major.service.MajorPlanGenParameter;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.plan.service.ProgramGenParameter;

public class ProgramNamingHelper {
    private static final String NAJOR_NAMING_FMT = "{0} {1}{2}";
    private static final String PERSONAL_NAMING_FMT = "{0}({1})\u4e2a\u4eba\u8ba1\u5212";

    public static String name(Program program, EntityDao entityDao) {
        return ProgramNamingHelper.name(entityDao, program.getGrade(), program.getMajor(), program.getDirection());
    }

    public static String name(Student std) {
        return MessageFormat.format(PERSONAL_NAMING_FMT, std.getName(), std.getCode());
    }

    public static String name(ProgramGenParameter genParameter, EntityDao entityDao) {
        return ProgramNamingHelper.name(entityDao, genParameter.getGrade(), genParameter.getMajor(), genParameter.getDirection());
    }

    public static String name(MajorPlanGenParameter genParameter, EntityDao entityDao) {
        return ProgramNamingHelper.name(entityDao, genParameter.getGrade(), genParameter.getMajor(), genParameter.getDirection());
    }

    private static String name(EntityDao entityDao, Grade grade, Major major, MajorDirection direction) {
        String gradeCode = ((Grade)entityDao.get(Grade.class, (Serializable)((Long)grade.getId()))).getCode();
        String majorName = ((Major)entityDao.get(Major.class, (Serializable)((Long)major.getId()))).getName();
        Object directionName = "";
        if (null != direction) {
            directionName = "/" + ((MajorDirection)entityDao.get(MajorDirection.class, (Serializable)((Long)direction.getId()))).getName();
        }
        return MessageFormat.format(NAJOR_NAMING_FMT, gradeCode, majorName, directionName);
    }
}

