/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.ClassLoaders;
import org.beangle.commons.lang.Strings;
import org.openurp.app.Urp;

public class UrpApp {
    public static UrpApp Instance = new UrpApp();
    private String name;
    private Map<String, String> properties = CollectUtils.newHashMap();

    public static String getName() {
        return UrpApp.Instance.name;
    }

    public UrpApp() {
        this.readProperties();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void readProperties() {
        List configs = ClassLoaders.getResources((String)"META-INF/openurp/app.properties", this.getClass());
        for (URL config : configs) {
            Properties p = new Properties();
            try {
                p.load(config.openStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (Object k : p.keySet()) {
                this.properties.put(k.toString(), p.getProperty(k.toString()).toString());
            }
        }
        if (!this.properties.containsKey("name")) {
            throw new RuntimeException("cannot find META-INF/openurp/app.properties");
        }
        this.name = this.properties.get("name");
    }

    public String getPath() {
        Object appPath = Strings.replace((String)this.name, (String)"-", (String)"/");
        appPath = "/" + Strings.replace((String)appPath, (String)".", (String)"/");
        return appPath;
    }

    public String getSecret() {
        String secret = this.properties.get("secret");
        if (null == secret) {
            return this.name;
        }
        return secret;
    }

    public static File getUrpAppFile() {
        File file = new File(Urp.getInstance().getHome() + Instance.getPath() + ".xml");
        if (!file.exists()) {
            file = new File(Urp.getInstance().getHome() + Instance.getPath() + ".json");
        }
        return file;
    }
}

