/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.edu.base.code.model.CourseType;
import org.openurp.edu.base.model.Direction;
import org.openurp.edu.program.plan.model.AbstractCourseGroup;
import org.openurp.edu.program.plan.model.CourseGroup;
import org.openurp.edu.program.plan.model.CoursePlan;
import org.openurp.edu.program.plan.model.MajorPlan;
import org.openurp.edu.program.plan.model.MajorPlanCourse;
import org.openurp.edu.program.plan.model.PlanCourse;

@Entity(name="org.openurp.edu.program.plan.model.MajorCourseGroup")
@Cacheable
@Cache(region="edu.course", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MajorCourseGroup
extends AbstractCourseGroup {
    private static final long serialVersionUID = -6804554057069134031L;
    @Size(max=40)
    private String alias;
    @ManyToOne(fetch=FetchType.LAZY)
    private Direction direction;
    @ManyToOne(targetEntity=MajorPlan.class)
    @JoinColumn(name="plan_id", updatable=false, insertable=false, nullable=false)
    private CoursePlan plan;
    @ManyToOne(targetEntity=MajorCourseGroup.class)
    @JoinColumn(name="parent_id", nullable=true)
    private CourseGroup parent;
    @OneToMany(targetEntity=MajorCourseGroup.class, cascade={CascadeType.ALL})
    @OrderBy(value="indexno")
    @JoinColumn(name="parent_id", nullable=true)
    @Cache(region="edu.course", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<CourseGroup> children = CollectUtils.newArrayList();
    @OneToMany(mappedBy="group", orphanRemoval=true, targetEntity=MajorPlanCourse.class, cascade={CascadeType.ALL})
    @Cache(region="edu.course", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<PlanCourse> planCourses = CollectUtils.newArrayList();

    public boolean isLeafGroup() {
        return null != this.alias;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (null != this.courseType) {
            sb.append(this.courseType.getName());
        }
        if (null != this.alias) {
            sb.append(" ").append(this.alias);
        }
        return sb.toString();
    }

    @Override
    public void setPlanCourses(List<PlanCourse> planCourses) {
        this.planCourses = planCourses;
    }

    @Override
    public List<CourseGroup> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List<CourseGroup> children) {
        this.children = children;
    }

    @Override
    public CoursePlan getPlan() {
        return this.plan;
    }

    @Override
    public void setPlan(CoursePlan plan) {
        this.plan = plan;
    }

    @Override
    public void addPlanCourses(List<PlanCourse> givenPlanCourses) {
        for (PlanCourse element : givenPlanCourses) {
            boolean finded = false;
            for (PlanCourse element2 : this.planCourses) {
                if (!((Long)element.getCourse().getId()).equals(element2.getCourse().getId())) continue;
                finded = true;
                break;
            }
            if (finded) continue;
            element.setGroup(this);
            this.planCourses.add(element);
        }
    }

    @Override
    public void updateCoursePlan(CoursePlan plan) {
        this.setPlan(plan);
        if (this.getChildren() != null) {
            for (CourseGroup group : this.getChildren()) {
                group.updateCoursePlan(plan);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MajorCourseGroup majorCourseGroup = (MajorCourseGroup)super.clone();
        majorCourseGroup.setId(null);
        majorCourseGroup.setParent(null);
        majorCourseGroup.setChildren(new ArrayList<CourseGroup>());
        majorCourseGroup.setPlanCourses(new ArrayList<PlanCourse>());
        return majorCourseGroup;
    }

    public List<PlanCourse> getMajorPlanCourses() {
        return this.planCourses;
    }

    @Override
    public List<PlanCourse> getPlanCourses() {
        return this.planCourses;
    }

    @Override
    public CourseGroup getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CourseGroup parent) {
        this.parent = parent;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MajorCourseGroup)) {
            return false;
        }
        MajorCourseGroup rhs = (MajorCourseGroup)object;
        return Objects.equalsBuilder().add((Object)this.id, (Object)rhs.id).isEquals();
    }

    private CourseType getParentCourseType() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getCourseType();
    }

    public boolean isSameGroup(Object object) {
        if (!(object instanceof MajorCourseGroup)) {
            return false;
        }
        MajorCourseGroup other = (MajorCourseGroup)object;
        return Objects.equalsBuilder().add((Object)Float.valueOf(this.getCredits()), (Object)Float.valueOf(other.getCredits())).add((Object)this.getCourseType(), (Object)other.getCourseType()).add((Object)this.getParentCourseType(), (Object)other.getParentCourseType()).add((Object)this.getRemark(), (Object)other.getRemark()).add((Object)this.getTermCredits(), (Object)other.getTermCredits()).add(this.getPlanCourses(), other.getPlanCourses()).isEquals();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public String toString() {
        return "MajorCourseGroup [alias=" + this.alias + ", direction=" + this.direction + ", parent=" + this.parent + ", courseType=" + this.courseType + "]";
    }
}

