/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.beangle.commons.io.IOs;
import org.beangle.commons.io.StringBuilderWriter;
import org.beangle.commons.lang.Charsets;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.web.util.HttpUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.openurp.app.Urp;
import org.openurp.app.UrpApp;
import org.openurp.app.util.AesEncryptor;
import org.openurp.app.util.DataSourceUtils;
import org.openurp.app.util.DatasourceConfig;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class AppDataSourceFactory
implements FactoryBean<DataSource>,
InitializingBean,
DisposableBean {
    private String url;
    private String user;
    private String password;
    private String driver;
    private String name;
    private Map<String, String> props = new HashMap<String, String>();
    private DataSource _result;

    public DataSource getObject() {
        return this._result;
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    public void destroy() {
        DataSourceUtils.close(this._result);
    }

    public boolean isSingleton() {
        return true;
    }

    public void fetchConf() {
        File appFile;
        if (null == this.name) {
            this.name = "default";
        }
        this.url = (appFile = UrpApp.getUrpAppFile()).exists() ? UrpApp.getUrpAppFile().getAbsolutePath() : Urp.getInstance().getApi() + "/platform/config/datasources/" + UrpApp.getName() + "/" + this.name + ".json?secret=" + UrpApp.Instance.getSecret();
        try {
            this.postInit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.fetchConf();
        this._result = DataSourceUtils.build(this.driver, this.user, this.password, this.props);
    }

    public void postInit() throws Exception {
        if (null != this.url) {
            boolean isXML = this.url.endsWith(".xml");
            if (this.url.startsWith("jdbc:")) {
                if (null == this.driver) {
                    this.driver = Strings.substringBetween((String)this.url, (String)"jdbc:", (String)":");
                    this.props.put("url", this.url);
                }
            } else if (this.url.startsWith("http")) {
                String text = HttpUtils.getResponseText((String)this.url);
                if (Strings.isNotBlank((CharSequence)text)) {
                    ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes());
                    this.merge(AppDataSourceFactory.readConf(is, this.name, isXML));
                }
            } else {
                File f = new File(this.url);
                URL urlAddr = f.exists() ? f.toURI().toURL() : new URL(this.url);
                this.merge(AppDataSourceFactory.readConf(urlAddr.openStream(), this.name, isXML));
            }
        }
        if (this.password != null && this.password.startsWith("?")) {
            this.password = new AesEncryptor(UrpApp.Instance.getSecret()).decrypt(this.password.substring(1));
        }
    }

    public static DatasourceConfig readConf(InputStream is, String dsname, boolean isXML) {
        DatasourceConfig conf = null;
        if (isXML) {
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read(is);
                List nodes = document.selectNodes("/app/resources/datasource");
                Set<String> predefined = Set.of("user", "password", "driver", "props");
                for (Object o : nodes) {
                    Node node;
                    String name;
                    if (!(o instanceof Node) || !(name = (node = (Node)o).valueOf("@name")).equals(dsname)) continue;
                    conf = new DatasourceConfig();
                    conf.user = node.selectSingleNode("user").getText();
                    conf.password = node.selectSingleNode("password").getText();
                    conf.driver = node.selectSingleNode("driver").getText();
                    conf.name = name;
                    List propNodes = node.selectNodes("props/prop");
                    for (Object po : propNodes) {
                        Node pn = (Node)po;
                        conf.props.put(pn.valueOf("@name"), pn.valueOf("@value"));
                    }
                    List children = node.selectNodes("*");
                    for (Object o1 : children) {
                        Node node1 = (Node)o1;
                        if (predefined.contains(node1.getName())) continue;
                        conf.props.put(node1.getName(), node1.getText());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            StringBuilderWriter sw = new StringBuilderWriter();
            Charset charset = Charsets.UTF_8;
            try {
                IOs.copy((Reader)new InputStreamReader(is, charset.name()), (Writer)sw);
                conf = new DatasourceConfig(DataSourceUtils.parseJson(sw.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return conf;
    }

    private void merge(DatasourceConfig conf) {
        if (null == this.user) {
            this.user = conf.user;
        }
        if (null == this.password) {
            this.password = conf.password;
        }
        if (null == this.driver) {
            this.driver = conf.driver;
        }
        if (null == this.name) {
            this.name = conf.name;
        }
        for (Map.Entry<String, String> e : conf.props.entrySet()) {
            if (this.props.containsKey(e.getKey())) continue;
            this.props.put(e.getKey(), e.getValue());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }
}

