/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app.util;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.sql.DataSource;
import org.beangle.commons.bean.PropertyUtils;
import org.openurp.app.util.DriverInfo;

public class DataSourceUtils {
    private static Map<String, DriverInfo> drivers = new HashMap<String, DriverInfo>();

    public static DataSource build(String driver, String username, String password, Map<String, String> props) {
        return new HikariDataSource(new HikariConfig(DataSourceUtils.buildProperties(driver, username, password, props)));
    }

    private static Properties buildProperties(String driver, String username, String password, Map<String, String> props) {
        Properties properties = new Properties();
        Set writables = PropertyUtils.getWritableProperties(HikariConfig.class);
        for (Map.Entry<String, String> e : props.entrySet()) {
            Object key;
            Object object = key = e.getKey().equals("url") ? "jdbcUrl" : e.getKey();
            if (!writables.contains(key)) {
                key = "dataSource." + (String)key;
            }
            properties.put(key, e.getValue());
        }
        if (driver.equals("oracle") && !properties.containsKey("jdbcUrl") && !props.containsKey("driverType")) {
            properties.put("dataSource.driverType", "thin");
        }
        if (null != username) {
            properties.put("username", username);
        }
        if (null != password) {
            properties.put("password", password);
        }
        if (properties.containsKey("jdbcUrl")) {
            try {
                Class.forName(DataSourceUtils.drivers.get((Object)driver).driverClassName);
            }
            catch (Exception exception) {}
        } else if (!properties.containsKey("dataSourceClassName")) {
            properties.put("dataSourceClassName", DataSourceUtils.drivers.get((Object)driver).dataSourceClassName);
        }
        return properties;
    }

    public static void close(DataSource dataSource) {
        if (dataSource instanceof HikariDataSource) {
            ((HikariDataSource)dataSource).close();
        } else {
            try {
                Method method = dataSource.getClass().getMethod("close", new Class[0]);
                if (null != method) {
                    method.invoke((Object)dataSource, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Map<String, String> parseJson(String string) {
        ScriptEngineManager sem = new ScriptEngineManager();
        ScriptEngine engine = sem.getEngineByName("javascript");
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap data = null;
        try {
            data = (HashMap)engine.eval("result =" + string);
        }
        catch (Exception e) {
            e.printStackTrace();
            data = new HashMap();
        }
        for (Map.Entry one : data.entrySet()) {
            Double d;
            String value = null;
            value = one.getValue() instanceof Double ? (Double.compare(d = (Double)one.getValue(), d.intValue()) > 0 ? d.toString() : String.valueOf(d.intValue())) : one.getValue().toString();
            String key = one.getKey().toString().equals("maxActive") ? "maxTotal" : one.getKey().toString();
            result.put(key, value);
        }
        return result;
    }

    static {
        drivers.put("postgresql", new DriverInfo("org.postgresql.Driver", "org.postgresql.ds.PGSimpleDataSource"));
        drivers.put("oracle", new DriverInfo("org.postgresql.Driver", "oracle.jdbc.pool.OracleDataSource"));
        drivers.put("jtds", new DriverInfo("net.sourceforge.jtds.jdbc.Driver", "net.sourceforge.jtds.jdbcx.JtdsDataSource"));
    }
}

