/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.model;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.Component;
import org.openurp.base.model.Department;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.edu.base.code.model.StdType;
import org.openurp.edu.base.model.Direction;
import org.openurp.edu.base.model.Major;
import org.openurp.edu.base.model.Project;

@Embeddable
public class StudentScope
implements Component {
    @Size(max=255)
    private String grades;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @ManyToMany
    private Set<EducationLevel> levels = new HashSet<EducationLevel>();
    @ManyToMany
    private Set<StdType> stdTypes = new HashSet<StdType>();
    @ManyToMany
    private Set<Department> departments = new HashSet<Department>();
    @ManyToMany
    private Set<Major> majors = new HashSet<Major>();
    @ManyToMany
    private Set<Direction> directions = new HashSet<Direction>();

    public Set<Department> getDepartments() {
        return this.departments;
    }

    public void setDepartments(Set<Department> departments) {
        this.departments = departments;
    }

    public Set<Major> getMajors() {
        return this.majors;
    }

    public void setMajors(Set<Major> majors) {
        this.majors = majors;
    }

    public Set<Direction> getDirections() {
        return this.directions;
    }

    public void setDirections(Set<Direction> directions) {
        this.directions = directions;
    }

    public String getGrades() {
        return this.grades;
    }

    public void setGrades(String grades) {
        this.grades = grades;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Set<StdType> getStdTypes() {
        return this.stdTypes;
    }

    public void setStdTypes(Set<StdType> stdTypes) {
        this.stdTypes = stdTypes;
    }

    public Set<EducationLevel> getLevels() {
        return this.levels;
    }

    public void setLevels(Set<EducationLevel> levels) {
        this.levels = levels;
    }

    public boolean overlappedWith(StudentScope scope) {
        return scope.getProject().equals(this.project) && CollectUtils.intersection(scope.getStdTypes(), this.stdTypes).size() > 0 && CollectUtils.intersection(scope.getLevels(), this.levels).size() > 0;
    }
}

