/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.time.WeekState;
import org.beangle.commons.lang.time.WeekTime;

public class WeekTimes {
    public static boolean canMergerWith(WeekTime me, WeekTime other) {
        if (me.getStartOn().equals(other.getStartOn())) {
            if (me.getWeekstate().equals(other.getWeekstate())) {
                if (me.getBeginAt().interval(other.getEndAt()) < 20 || other.getBeginAt().interval(me.getEndAt()) < 20) {
                    return true;
                }
                return me.getBeginAt().value <= other.getEndAt().value && other.getBeginAt().value <= me.getEndAt().value;
            }
            return me.getBeginAt().equals(other.getBeginAt()) && me.getEndAt().equals(other.getEndAt());
        }
        return false;
    }

    public static void mergeWith(WeekTime me, WeekTime other) {
        if (me.getWeekstate().equals(other.getWeekstate())) {
            if (other.getBeginAt().value < me.getBeginAt().value) {
                me.setBeginAt(other.getBeginAt());
            }
            if (other.getEndAt().value > me.getEndAt().value) {
                me.setEndAt(other.getEndAt());
            }
        } else {
            me.setWeekstate(new WeekState(me.getWeekstate().value | other.getWeekstate().value));
        }
    }

    public static List<WeekTime> mergeTimes(List<WeekTime> tobeMerged) {
        if (tobeMerged.isEmpty()) {
            return tobeMerged;
        }
        Collections.sort(tobeMerged);
        List mergedTimeUnits = CollectUtils.newArrayList();
        Iterator<WeekTime> activityIter = tobeMerged.iterator();
        WeekTime toMerged = activityIter.next();
        mergedTimeUnits.add(toMerged);
        while (activityIter.hasNext()) {
            WeekTime unit = activityIter.next();
            if (WeekTimes.canMergerWith(toMerged, unit)) {
                WeekTimes.mergeWith(toMerged, unit);
                continue;
            }
            toMerged = unit;
            mergedTimeUnits.add(toMerged);
        }
        return mergedTimeUnits;
    }
}

