/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app.security.service;

import com.google.gson.Gson;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.web.util.HttpUtils;
import org.beangle.security.authz.AbstractRoleBasedAuthorizer;
import org.beangle.security.authz.Authority;
import org.beangle.security.authz.AuthorityDomain;
import org.openurp.app.Urp;
import org.openurp.app.UrpApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAuthorizer
extends AbstractRoleBasedAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(RemoteAuthorizer.class);

    protected AuthorityDomain fetchDomain() {
        Set<String> roots = RemoteAuthorizer.getRoots();
        List<Authority> authorityList = RemoteAuthorizer.getResources();
        Map authorities = CollectUtils.newHashMap();
        for (Authority a : authorityList) {
            authorities.put(a.getResourceName(), a);
        }
        return new AuthorityDomain(roots, authorities);
    }

    public static Set<String> getRoots() {
        String url = Urp.Instance.getApi() + "/platform/user/roots.json?app=" + UrpApp.getName();
        try {
            String resources = HttpUtils.getResponseText((String)url);
            List rs = (List)new Gson().fromJson(resources, List.class);
            return new HashSet<String>(rs);
        }
        catch (Exception e) {
            logger.error("Cannot access {}", (Object)url);
            return Collections.emptySet();
        }
    }

    public static List<Authority> getResources() {
        String url = Urp.Instance.getApi() + "/platform/security/func/" + UrpApp.getName() + "/resources.json";
        try {
            String resources = HttpUtils.getResponseText((String)url);
            return RemoteAuthorizer.toAuthorities(resources);
        }
        catch (Exception e) {
            logger.error("Cannot access {}", (Object)url);
            return Collections.emptyList();
        }
    }

    public static List<Authority> toAuthorities(String resources) {
        List rs = (List)new Gson().fromJson(resources, List.class);
        Set s = CollectUtils.newHashSet();
        List authorities = CollectUtils.newArrayList();
        for (Object o : rs) {
            Map m = (Map)o;
            s.add(m.get("name").toString());
            List roleList = (List)m.get("roles");
            Set roles = roleList.stream().map(x -> String.valueOf(((Number)x).intValue())).collect(Collectors.toSet());
            Authority a = new Authority(m.get("name").toString(), m.get("scope").toString(), roles);
            authorities.add(a);
        }
        return authorities;
    }
}

