/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.time;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.text.i18n.TextResource;
import org.openurp.base.time.NumberRange;
import org.openurp.base.time.NumberRangeFormatter;

public class NumberRangeDigestor {
    public static String digest(int[] numberSequence, TextResource textResource) {
        return NumberRangeDigestor.digest(numberSequence, textResource, NumberRangeFormatter.getInstance());
    }

    public static String digest(int[] numberSequence, TextResource textResource, NumberRangeFormatter formatter) {
        if (numberSequence == null || numberSequence.length == 0) {
            return "";
        }
        Arrays.sort(numberSequence);
        List patterns = CollectUtils.newArrayList();
        NumberRange lastPattern = NumberRange.newInstance(numberSequence[0]);
        patterns.add(lastPattern);
        for (int i = 1; i < numberSequence.length; ++i) {
            int number = numberSequence[i];
            if (lastPattern.test(number)) continue;
            lastPattern = lastPattern.guessNextPattern(number);
            patterns.add(lastPattern);
        }
        StringBuilder sb = new StringBuilder();
        Iterator iterator = patterns.iterator();
        while (iterator.hasNext()) {
            NumberRange pattern = (NumberRange)iterator.next();
            if (pattern.isAbandon()) continue;
            sb.append(formatter.format(pattern, textResource, iterator.hasNext()));
        }
        return sb.toString();
    }

    public static String digest(Integer[] numberSequence, TextResource textResource) {
        if (numberSequence == null || numberSequence.length == 0) {
            return "";
        }
        int[] integers = new int[numberSequence.length];
        for (int i = 0; i < numberSequence.length; ++i) {
            integers[i] = numberSequence[i];
        }
        return NumberRangeDigestor.digest(integers, textResource);
    }

    public static String digest(Integer[] numberSequence, TextResource textResource, NumberRangeFormatter formatter) {
        if (numberSequence == null || numberSequence.length == 0) {
            return null;
        }
        int[] integers = new int[numberSequence.length];
        for (int i = 0; i < numberSequence.length; ++i) {
            integers[i] = numberSequence[i];
        }
        return NumberRangeDigestor.digest(integers, textResource, formatter);
    }
}

