/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.graduation.plan.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.bean.comparators.PropertyComparator;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.Strings;
import org.hibernate.annotations.Type;
import org.openurp.base.time.Terms;
import org.openurp.edu.base.model.Course;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.model.ExamGrade;
import org.openurp.edu.graduation.plan.model.GroupAuditResult;
import org.openurp.edu.program.plan.model.PlanCourse;

@Entity(name="org.openurp.edu.graduation.plan.model.CourseAuditResult")
public class CourseAuditResult
extends LongIdObject {
    private static final long serialVersionUID = 7271307757012360755L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private GroupAuditResult groupResult;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Course course;
    @Size(max=100)
    private String scores;
    private boolean passed;
    private boolean compulsory;
    @NotNull
    @Type(type="org.openurp.base.time.hibernate.TermsType")
    protected Terms terms = Terms.Empty;
    @Size(max=500)
    private String remark;

    public CourseAuditResult() {
    }

    public CourseAuditResult(PlanCourse planCourse) {
        this.course = planCourse.getCourse();
        this.compulsory = planCourse.isCompulsory();
    }

    public CourseAuditResult init(PlanCourse planCourse) {
        this.course = planCourse.getCourse();
        this.compulsory = planCourse.isCompulsory();
        return this;
    }

    public GroupAuditResult getGroupResult() {
        return this.groupResult;
    }

    public void setGroupResult(GroupAuditResult groupResult) {
        this.groupResult = groupResult;
    }

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public void setPassed(boolean passed) {
        this.passed = passed;
    }

    public void checkPassed(List<CourseGrade> grades) {
        StringBuilder sb = new StringBuilder();
        if (CollectUtils.isEmpty(grades)) {
            this.scores = "--";
        } else {
            for (CourseGrade grade : grades) {
                sb.append((String)Strings.defaultIfBlank((CharSequence)grade.getScoreText(), (CharSequence)"--")).append(" ");
                if (this.passed) continue;
                this.passed = grade.isPassed();
            }
            this.scores = sb.toString();
        }
        if (!this.passed && !grades.isEmpty()) {
            ArrayList<CourseGrade> newGrades = new ArrayList<CourseGrade>(grades);
            StringBuilder remarkSB = new StringBuilder();
            Collections.sort(newGrades, new PropertyComparator("semester"));
            String brString = "";
            for (CourseGrade grade : newGrades) {
                remarkSB.append(brString);
                remarkSB.append(grade.getSemester().getSchoolYear()).append(grade.getSemester().getName()).append(" ");
                for (ExamGrade examGrade : grade.getExamGrades()) {
                    remarkSB.append(examGrade.getGradeType().getName()).append(" ");
                    if (Strings.isNotBlank((CharSequence)examGrade.getScoreText())) {
                        remarkSB.append(examGrade.getScoreText()).append(" ");
                        continue;
                    }
                    remarkSB.append(examGrade.getExamStatus().getName()).append(" ");
                }
                brString = "\n";
            }
            this.remark = remarkSB.toString();
        }
    }

    public void checkPassed(List<CourseGrade> grades, List<CourseGrade> substituteGrades) {
        this.checkPassed(grades);
        if (!this.passed && !substituteGrades.isEmpty()) {
            Map courseId2passed = CollectUtils.newHashMap();
            for (CourseGrade subGrade : substituteGrades) {
                Boolean courseIdPassed = (Boolean)courseId2passed.get(subGrade.getCourse().getId());
                if (courseIdPassed == null) {
                    courseIdPassed = subGrade.isPassed();
                }
                courseIdPassed = courseIdPassed | subGrade.isPassed();
                courseId2passed.put((Long)subGrade.getCourse().getId(), courseIdPassed);
            }
            this.passed = true;
            for (Long courseId : courseId2passed.keySet()) {
                this.passed &= ((Boolean)courseId2passed.get(courseId)).booleanValue();
            }
            StringBuffer tempStr = new StringBuffer();
            Iterator<CourseGrade> iter = substituteGrades.iterator();
            while (iter.hasNext()) {
                CourseGrade grade = iter.next();
                tempStr.append(grade.getCourse().getName()).append('[').append(grade.getCourse().getCode()).append(']').append("\n");
                tempStr.append(grade.getSemester().getSchoolYear()).append(grade.getSemester().getName()).append(" ");
                for (ExamGrade examGrade : grade.getExamGrades()) {
                    tempStr.append(examGrade.getGradeType().getName()).append(" ");
                    if (Strings.isNotBlank((CharSequence)examGrade.getScoreText())) {
                        tempStr.append(examGrade.getScoreText()).append(" ");
                        continue;
                    }
                    tempStr.append(examGrade.getExamStatus().getName()).append(" ");
                }
                if (!iter.hasNext()) continue;
                tempStr.append('\n');
            }
            this.remark = tempStr.toString();
        }
    }

    public boolean isCompulsory() {
        return this.compulsory;
    }

    public void setCompulsory(boolean compulsory) {
        this.compulsory = compulsory;
    }

    public String getScores() {
        return this.scores;
    }

    public void setScores(String scores) {
        this.scores = scores;
    }

    public Terms getTerms() {
        return this.terms;
    }

    public void setTerms(Terms terms) {
        this.terms = terms;
    }
}

