/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.metadata.Model;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Target;
import org.openurp.code.edu.model.Language;
import org.openurp.edu.base.code.model.CourseAbilityRate;
import org.openurp.edu.program.plan.model.AbstractCourseGroup;
import org.openurp.edu.program.plan.model.CourseGroup;
import org.openurp.edu.program.plan.model.CoursePlan;
import org.openurp.edu.program.plan.model.MajorCourseGroup;
import org.openurp.edu.program.plan.model.PlanCourse;
import org.openurp.edu.program.plan.model.SharePlan;
import org.openurp.edu.program.plan.model.SharePlanCourse;

@Entity(name="org.openurp.edu.program.plan.model.ShareCourseGroup")
public class ShareCourseGroup
extends AbstractCourseGroup {
    private static final long serialVersionUID = -6481752967441999886L;
    @Target(value=SharePlan.class)
    @ManyToOne(fetch=FetchType.LAZY)
    private CoursePlan plan;
    @Target(value=ShareCourseGroup.class)
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseGroup parent;
    @OneToMany(targetEntity=ShareCourseGroup.class, mappedBy="parent")
    @OrderBy(value="indexno")
    @Cascade(value={CascadeType.ALL})
    private List<CourseGroup> children = CollectUtils.newArrayList();
    @OneToMany(mappedBy="group", targetEntity=SharePlanCourse.class)
    @Cascade(value={CascadeType.ALL})
    protected List<PlanCourse> planCourses = CollectUtils.newArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    protected Language language;
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseAbilityRate abilityRate;

    @Override
    public Object clone() throws CloneNotSupportedException {
        ShareCourseGroup courseGroup = (ShareCourseGroup)super.clone();
        courseGroup.setId(null);
        List<CourseGroup> groups = courseGroup.getChildren();
        List groupClones = CollectUtils.newArrayList();
        for (CourseGroup cg : groups) {
            CourseGroup groupClone = (CourseGroup)cg.clone();
            groupClones.add(groupClone);
            groupClone.setParent(courseGroup);
        }
        courseGroup.setChildren(groupClones);
        courseGroup.setPlanCourses(new ArrayList<PlanCourse>());
        for (PlanCourse planCourse : this.getPlanCourses()) {
            courseGroup.addPlanCourse((PlanCourse)planCourse.clone());
        }
        return courseGroup;
    }

    public Object cloneToMajorCourseGroup() {
        MajorCourseGroup courseGroup = (MajorCourseGroup)Model.newInstance(MajorCourseGroup.class);
        courseGroup.setCourseCount(this.getCourseCount());
        courseGroup.setCourseType(this.getCourseType());
        courseGroup.setCredits(this.getCredits());
        courseGroup.setIndexno(this.getIndexno());
        courseGroup.setTermCredits(this.getTermCredits());
        courseGroup.setRemark(this.getRemark());
        courseGroup.setChildren(new ArrayList<CourseGroup>());
        courseGroup.setPlanCourses(new ArrayList<PlanCourse>());
        courseGroup.setId(null);
        return courseGroup;
    }

    @Override
    public void setPlanCourses(List<PlanCourse> planCourses) {
        this.planCourses = planCourses;
    }

    @Override
    public List<CourseGroup> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List<CourseGroup> children) {
        this.children = children;
    }

    @Override
    public CoursePlan getPlan() {
        return this.plan;
    }

    @Override
    public void setPlan(CoursePlan plan) {
        this.plan = plan;
    }

    @Override
    public CourseGroup getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CourseGroup parent) {
        this.parent = parent;
    }

    @Override
    public void addPlanCourses(List<PlanCourse> givenPlanCourses) {
        for (PlanCourse element : givenPlanCourses) {
            boolean finded = false;
            for (PlanCourse element2 : this.planCourses) {
                if (!((Long)element.getCourse().getId()).equals(element2.getCourse().getId())) continue;
                finded = true;
                break;
            }
            if (finded) continue;
            element.setGroup(this);
            this.planCourses.add(element);
        }
    }

    @Override
    public void updateCoursePlan(CoursePlan plan) {
        this.setPlan(plan);
        if (this.getChildren() != null) {
            for (CourseGroup group : this.getChildren()) {
                group.updateCoursePlan(plan);
            }
        }
    }

    @Override
    public List<PlanCourse> getPlanCourses() {
        return this.planCourses;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public CourseAbilityRate getAbilityRate() {
        return this.abilityRate;
    }

    public void setAbilityRate(CourseAbilityRate abilityRate) {
        this.abilityRate = abilityRate;
    }
}

