/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.app.web

import org.beangle.webmvc.api.action.ServletSupport
import org.beangle.webmvc.api.annotation.ignore
import org.beangle.webmvc.entity.action.EntityAction
import org.beangle.data.dao.OqlBuilder
import org.openurp.edu.base.model.Project

trait ProjectSupport extends ServletSupport {
  self: EntityAction[_] =>

  @ignore
  def projectCode: String = {
    val p = getCookieValue("project")
    if (null == p) {
      request.getServerName
    } else {
      p
    }
  }

  @ignore
  def project: Project = {
    val builder = OqlBuilder.from(classOf[Project], "p").where("p.code=:code", projectCode).cacheable()
    val projects = entityDao.search(builder)
    projects.head
  }
}
