/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.boot.web
import java.time.LocalDate

import scala.collection.mutable.Buffer

import org.beangle.data.dao.OqlBuilder
import org.beangle.data.model.Entity
import org.beangle.webmvc.api.action.ServletSupport
import org.beangle.webmvc.api.annotation.ignore
import org.beangle.webmvc.entity.action.EntityAction
import org.openurp.code.Code
import org.openurp.edu.base.model.Project

trait ProjectSupport extends ServletSupport { this: EntityAction[_] =>

  def getCodes[T](clazz: Class[T]): Seq[T] = {
    val query = OqlBuilder.from(clazz, "c")
    if (classOf[Code].isAssignableFrom(clazz)) {
      query.where("c.endOn is null or :now between c.beginOn and c.endOn", LocalDate.now)
    }
    query.cacheable()
    entityDao.search(query)
  }

  def findInSchool[T <: Entity[_]](clazz: Class[T]): Seq[T] = {
    val query = OqlBuilder.from(clazz, "aa")
    query.where("aa.school=:school", getProject().school)
    query.orderBy("code")
    entityDao.search(query)
  }

  def findInProject[T <: Entity[_]](clazz: Class[T], orderBy: String = "code"): Seq[T] = {
    val query = OqlBuilder.from(clazz, "aa")
    query.where("aa.project=:project", getProject())
    query.orderBy(orderBy)
    entityDao.search(query)
  }

  @ignore
  def getProjectCode: String = {
    val p = getCookieValue("project")
    if (null == p) {
      request.getServerName
    } else {
      p
    }
  }

  @ignore
  def getProject(): Project = {
    val pcode = getProjectCode
    val builder = OqlBuilder.from(classOf[Project], "p").where("p.code=:code", pcode).cacheable()
    val projects = entityDao.search(builder)
    var project: Project = null
    if (projects.isEmpty) {
      val ps = entityDao.getAll(classOf[Project])
      if (ps.size == 1) {
        project = ps.head
      }
    } else {
      project = projects.head
    }

    if (null != project && pcode != project.code) {
      addCookie("project", project.code, -1)
    }
    project
  }
}
