/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.impl;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.data.dao.EntityDao;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.code.edu.model.GradingMode$;
import org.openurp.edu.grade.model.CourseGradeState;
import org.openurp.edu.grade.model.ExamGradeState;
import org.openurp.edu.grade.model.GaGradeState;
import org.openurp.edu.grade.model.Grade;
import org.openurp.edu.grade.model.GradeState;
import org.openurp.edu.grade.service.GradingModeStrategy;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class DefaultGradingModeStrategy
implements GradingModeStrategy {
    private EntityDao entityDao;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    private boolean isDefault(GradingMode style) {
        return style == null || BoxesRunTime.unboxToInt((Object)style.id()) == GradingMode$.MODULE$.Percent();
    }

    @Override
    public void configGradingMode(CourseGradeState gradeState, List<GradeType> gradeTypes) {
        if (this.isDefault(gradeState.gradingMode())) {
            gradeState.gradingMode_$eq(this.getDefaultCourseGradeGradingMode(gradeState));
        }
        gradeTypes.foreach((Function1)(JProcedure1 & Serializable)t -> {
            GradeState typeState = this.getState(gradeState, (GradeType)t);
            if (typeState.gradingMode() == null) {
                typeState.gradingMode_$eq(this.getDefaultExamGradeGradingMode(gradeState, typeState));
                return;
            }
        });
        this.entityDao().saveOrUpdate((Object)gradeState, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseGradeState[0]));
    }

    public GradingMode getDefaultCourseGradeGradingMode(CourseGradeState state) {
        Set modes = state.clazz().course().gradingModes();
        if (modes.isEmpty()) {
            return (GradingMode)this.entityDao().get(GradingMode.class, (Object)BoxesRunTime.boxToInteger((int)GradingMode$.MODULE$.Percent()));
        }
        return (GradingMode)modes.head();
    }

    public GradingMode getDefaultExamGradeGradingMode(CourseGradeState gradeState, GradeState typeState) {
        if (typeState.gradeType().isGa()) {
            return gradeState.gradingMode();
        }
        if (BoxesRunTime.unboxToInt((Object)typeState.gradeType().id()) == GradeType$.MODULE$.Delay()) {
            ExamGradeState endGradeState = (ExamGradeState)gradeState.getState(new GradeType(GradeType$.MODULE$.End()));
            if (endGradeState == null) {
                return gradeState.gradingMode();
            }
            return endGradeState.gradingMode();
        }
        return (GradingMode)this.entityDao().get(GradingMode.class, (Object)BoxesRunTime.boxToInteger((int)GradingMode$.MODULE$.Percent()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GradeState getState(CourseGradeState gs, GradeType gradeType) {
        GaGradeState gaGradeState;
        if (gradeType.isGa()) {
            Option option = gs.gaStates().find((Function1 & Serializable)_$2 -> BoxesRunTime.unboxToInt((Object)_$2.gradeType().id()) == BoxesRunTime.unboxToInt((Object)gradeType.id()));
            if (None$.MODULE$.equals(option)) {
                GaGradeState result = new GaGradeState();
                result.status_$eq(Grade.Status$.MODULE$.New());
                result.updatedAt_$eq(Instant.now());
                result.gradeType_$eq(gradeType);
                result.gradeState_$eq(gs);
                gs.gaStates().$plus$eq((Object)result);
                gaGradeState = result;
                return (GradeState)gaGradeState;
            } else {
                GaGradeState result;
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                gaGradeState = result = (GaGradeState)((Some)option).value();
            }
            return (GradeState)gaGradeState;
        } else {
            Option option = gs.examStates().find((Function1 & Serializable)_$3 -> BoxesRunTime.unboxToInt((Object)_$3.gradeType().id()) == BoxesRunTime.unboxToInt((Object)gradeType.id()));
            if (None$.MODULE$.equals(option)) {
                ExamGradeState result = new ExamGradeState();
                result.status_$eq(Grade.Status$.MODULE$.New());
                result.updatedAt_$eq(Instant.now());
                result.gradeType_$eq(gradeType);
                result.gradeState_$eq(gs);
                gs.examStates().$plus$eq((Object)result);
                gaGradeState = result;
                return (GradeState)gaGradeState;
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                ExamGradeState result = (ExamGradeState)((Some)option).value();
                gaGradeState = result;
            }
        }
        return (GradeState)gaGradeState;
    }
}

