/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.extern.service.signup.impl;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.model.Project;
import org.openurp.base.std.model.Student;
import org.openurp.edu.extern.config.CertSignupConfig;
import org.openurp.edu.extern.config.CertSignupSetting;
import org.openurp.edu.extern.model.CertSignup;
import org.openurp.edu.extern.service.signup.CertSignupChecker;
import org.openurp.edu.extern.service.signup.CertSignupChecker$;
import org.openurp.edu.extern.service.signup.CertSignupService;
import scala.Function1;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class DefaultCertSignupService
implements CertSignupService {
    private EntityDao entityDao;
    private Buffer checkerStack = ArrayBuffer$.MODULE$.empty();

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public Buffer<CertSignupChecker> checkerStack() {
        return this.checkerStack;
    }

    public void checkerStack_$eq(Buffer<CertSignupChecker> x$1) {
        this.checkerStack = x$1;
    }

    @Override
    public String signup(CertSignup signup, CertSignupSetting setting) {
        String msg = this.canSignup(signup.std(), setting);
        if (Strings$.MODULE$.isEmpty((CharSequence)msg)) {
            block7: {
                if (setting.maxStd() >= 0) {
                    CertSignupSetting certSignupSetting = setting;
                    synchronized (certSignupSetting) {
                        String string;
                        block6: {
                            int countStd = this.getSignupCount(setting);
                            if (setting.maxStd() <= countStd) {
                                string = "\u8d85\u8fc7\u6700\u5927\u62a5\u540d\u4eba\u6570";
                                break block6;
                            }
                            break block7;
                        }
                        return string;
                    }
                }
            }
            signup.semester_$eq(setting.config().semester());
            signup.subject_$eq(setting.subject());
            signup.updatedAt_$eq(Instant.now());
            this.entityDao().saveOrUpdate((Object)signup, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertSignup[0]));
        }
        return msg;
    }

    private int getSignupCount(CertSignupSetting setting) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CertSignup.class.getName(), "signup");
        query.where("signup.semester = :semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setting.config().semester()}));
        query.where("signup.subject = :subject", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setting.subject()}));
        query.select("count(*)");
        return ((Number)this.entityDao().search((QueryBuilder)query).head()).intValue();
    }

    @Override
    public String canSignup(Student student, CertSignupSetting setting) {
        ObjectRef msg = ObjectRef.create(null);
        this.checkerStack().withFilter((Function1 & Serializable)checker -> (String)msg$1.elem == null).foreach((Function1)(JProcedure1 & Serializable)checker -> {
            String string = checker.check(student, setting);
            msg$2.elem = string;
            string = null;
        });
        return (String)msg.elem;
    }

    @Override
    public String cancel(Student std, CertSignupSetting setting) {
        if (!setting.config().opened() || !setting.config().isTimeSuitable()) {
            return CertSignupChecker$.MODULE$.notInTime();
        }
        this.get(std, setting).foreach((Function1)(JProcedure1 & Serializable)signup -> this.entityDao().remove(signup, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertSignup[0])));
        return null;
    }

    @Override
    public Option<CertSignup> get(Student std, CertSignupSetting setting) {
        CertSignupConfig config = setting.config();
        OqlBuilder query = OqlBuilder$.MODULE$.from(CertSignup.class, "signup");
        query.where("signup.std = :std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query.where("signup.updatedAt between :start and :end", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{config.beginAt(), config.endAt()}));
        query.where("signup.subject = :subject", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setting.subject()}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    @Override
    public Seq<CertSignup> get(Student std, CertSignupConfig config) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CertSignup.class, "signup");
        query.where("signup.std = :std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query.where("signup.updatedAt between :start and :end", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{config.beginAt(), config.endAt()}));
        return this.entityDao().search((QueryBuilder)query);
    }

    @Override
    public Iterable<CertSignup> search(Student std, LocalDate start, LocalDate end) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CertSignup.class, "signup");
        query.where("signup.std = :std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query.where("signup.updatedAt between :start and :end", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{start, end}));
        return this.entityDao().search((QueryBuilder)query);
    }

    @Override
    public Iterable<CertSignup> search(Student std, CertSignupConfig config) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CertSignup.class, "signup");
        query.where("signup.semester = :semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{config.semester()}));
        query.where("signup.std = :std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query.where("signup.subject in (:subjects)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{config.subjects()}));
        return this.entityDao().search((QueryBuilder)query);
    }

    @Override
    public Iterable<CertSignupSetting> getOpenedSettings(Project project) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CertSignupSetting.class, "setting");
        query.where("setting.config.opened = true", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.where("setting.config.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.where(":now  between setting.config.beginAt and setting.config.endAt", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Instant.now()}));
        return this.entityDao().search((QueryBuilder)query);
    }

    @Override
    public Iterable<CertSignupConfig> getOpenedConfigs(Project project) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CertSignupConfig.class, "config");
        query.where("config.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.where("config.opened = true", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.where(":time between config.beginAt and config.endAt ", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Instant.now()}));
        return this.entityDao().search((QueryBuilder)query);
    }

    @Override
    public boolean isExist(CertSignup signup) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(CertSignup.class, "signup");
        builder.where("signup.subject  =:subject", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{signup.subject()}));
        builder.where("signup.semester  =:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{signup.semester()}));
        builder.where("signup.std =:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{signup.std()}));
        if (signup.persisted()) {
            builder.where("signup.id <>:id", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{signup.id()}));
        }
        return this.entityDao().search((QueryBuilder)builder).nonEmpty();
    }
}

