/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.impl;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.bean.orderings.PropertyOrdering;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Objects$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.Operation;
import org.beangle.data.dao.Operation$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.security.Securities$;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectPropertyService;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.grade.BaseServiceImpl;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.CourseGradeState;
import org.openurp.edu.grade.model.ExamGrade;
import org.openurp.edu.grade.model.ExamGradeState;
import org.openurp.edu.grade.model.GaGrade;
import org.openurp.edu.grade.model.GaGradeState;
import org.openurp.edu.grade.model.Grade;
import org.openurp.edu.grade.model.GradeState;
import org.openurp.edu.grade.service.ClazzGradeService;
import org.openurp.edu.grade.service.CourseGradeCalculator;
import org.openurp.edu.grade.service.CourseGradePublishStack;
import org.openurp.edu.grade.service.CourseGradeSetting;
import org.openurp.edu.grade.service.CourseGradeSettings;
import org.openurp.edu.grade.service.GradingModeStrategy;
import org.openurp.edu.grade.service.ScoreConverter;
import org.openurp.edu.program.domain.CoursePlanProvider;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class ClazzGradeServiceImpl
extends BaseServiceImpl
implements ClazzGradeService {
    private CourseGradeCalculator calculator;
    private CoursePlanProvider coursePlanProvider;
    private GradingModeStrategy gradingModeStrategy;
    private CourseGradePublishStack publishStack;
    private ProjectPropertyService projectPropertyService;
    private CourseGradeSettings settings;

    public CourseGradeCalculator calculator() {
        return this.calculator;
    }

    public void calculator_$eq(CourseGradeCalculator x$1) {
        this.calculator = x$1;
    }

    public CoursePlanProvider coursePlanProvider() {
        return this.coursePlanProvider;
    }

    public void coursePlanProvider_$eq(CoursePlanProvider x$1) {
        this.coursePlanProvider = x$1;
    }

    public GradingModeStrategy gradingModeStrategy() {
        return this.gradingModeStrategy;
    }

    public void gradingModeStrategy_$eq(GradingModeStrategy x$1) {
        this.gradingModeStrategy = x$1;
    }

    public CourseGradePublishStack publishStack() {
        return this.publishStack;
    }

    public void publishStack_$eq(CourseGradePublishStack x$1) {
        this.publishStack = x$1;
    }

    public ProjectPropertyService projectPropertyService() {
        return this.projectPropertyService;
    }

    public void projectPropertyService_$eq(ProjectPropertyService x$1) {
        this.projectPropertyService = x$1;
    }

    public CourseGradeSettings settings() {
        return this.settings;
    }

    public void settings_$eq(CourseGradeSettings x$1) {
        this.settings = x$1;
    }

    @Override
    public Seq<GradeType> getPublishableGradeTypes(Project project) {
        Seq gradeTypes = this.entityDao().getAll(GradeType.class);
        gradeTypes = (Seq)gradeTypes.filter((Function1 & Serializable)input -> input.isGa() || BoxesRunTime.unboxToInt((Object)input.id()) == GradeType$.MODULE$.Final());
        return (Seq)gradeTypes.sorted((Ordering)new PropertyOrdering("code"));
    }

    @Override
    public void recalculate(CourseGradeState gradeState) {
        if (gradeState == null) {
            return;
        }
        Buffer published = Collections$.MODULE$.newBuffer();
        gradeState.examStates().withFilter((Function1 & Serializable)egs -> egs.status() == Grade.Status$.MODULE$.Published()).foreach((Function1 & Serializable)egs -> (Buffer)published.$plus$eq((Object)egs.gradeType()));
        gradeState.gaStates().withFilter((Function1 & Serializable)egs -> egs.status() == Grade.Status$.MODULE$.Published()).foreach((Function1 & Serializable)egs -> (Buffer)published.$plus$eq((Object)egs.gradeType()));
        Seq<CourseGrade> grades = this.getGrades(gradeState.clazz());
        grades.foreach((Function1)(JProcedure1 & Serializable)grade -> {
            this.updateGradeState((Grade)grade, (GradeState)gradeState, grade.project());
            gradeState.examStates().foreach((Function1)(JProcedure1 & Serializable)state -> {
                GradeType gradeType = state.gradeType();
                grade.getExamGrade(gradeType).foreach((Function1)(JProcedure1 & Serializable)eg -> this.updateGradeState((Grade)eg, (GradeState)state, grade.project()));
            });
            this.calculator().calcAll((CourseGrade)grade, gradeState);
        });
        this.entityDao().saveOrUpdate(grades);
        if (!published.isEmpty()) {
            this.publish(gradeState.clazz().id().toString(), (GradeType[])published.toArray(ClassTag$.MODULE$.apply(GradeType.class)), true);
            return;
        }
    }

    private Seq<CourseGrade> getGrades(Clazz clazz) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseGrade.class, "courseGrade");
        query.where("courseGrade.clazz = :clazz", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz}));
        query.where("courseGrade.courseTakeType.id != :ignored", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption())}));
        return this.entityDao().search((QueryBuilder)query);
    }

    @Override
    public void publish(String clazzIdSeq, GradeType[] gradeTypes, boolean published) {
        Seq ids2 = Strings$.MODULE$.splitToLong(clazzIdSeq);
        long[] ids = new long[ids2.length()];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ids.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ids$1[i] = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)ids2.apply(i)));
        });
        Seq clazzes = this.entityDao().find(Clazz.class, (Iterable)Predef$.MODULE$.wrapLongArray(ids).toList());
        if (Collections$.MODULE$.isNotEmpty((Iterable)clazzes)) {
            clazzes.foreach((Function1)(JProcedure1 & Serializable)clazz -> this.updateState((Clazz)clazz, gradeTypes, published ? Grade.Status$.MODULE$.Published() : Grade.Status$.MODULE$.New()));
            return;
        }
    }

    private void updateState(Clazz clazz, GradeType[] gradeTypes, int status) {
        Seq courseGradeStates = this.entityDao().findBy(CourseGradeState.class, "clazz", (Object)clazz);
        ObjectRef gradeState = ObjectRef.create(null);
        Object object = Predef$.MODULE$.refArrayOps((Object[])gradeTypes);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)gradeType -> {
            CourseGradeState courseGradeState = courseGradeStates.isEmpty() ? new CourseGradeState() : (CourseGradeState)courseGradeStates.head();
            gradeState$2.elem = courseGradeState;
            courseGradeState = null;
            if (BoxesRunTime.unboxToInt((Object)gradeType.id()) == GradeType$.MODULE$.Final()) {
                ((CourseGradeState)gradeState$2.elem).status_$eq(status);
                return;
            }
            ((CourseGradeState)gradeState$2.elem).updateStatus(gradeType, status);
        });
        Seq<CourseGrade> grades = this.getGrades(clazz);
        Buffer toBeSaved = Collections$.MODULE$.newBuffer();
        Set published = Collections$.MODULE$.newSet();
        grades.withFilter((Function1 & Serializable)grade -> BoxesRunTime.unboxToInt((Object)grade.courseTakeType().id()) != CourseTakeType$.MODULE$.Exemption()).foreach((Function1)(JProcedure1 & Serializable)grade -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])gradeTypes);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)gradeType -> {
                BooleanRef updated = BooleanRef.create((boolean)false);
                if (BoxesRunTime.unboxToInt((Object)gradeType.id()) == GradeType$.MODULE$.Final()) {
                    boolean bl;
                    grade.status_$eq(status);
                    updated.elem = bl = true;
                } else {
                    grade.getGrade(gradeType).foreach((Function1)(JProcedure1 & Serializable)examGrade -> {
                        boolean bl;
                        examGrade.status_$eq(status);
                        updated$1.elem = bl = true;
                    });
                }
                if (updated.elem) {
                    published.$plus$eq(grade);
                    return;
                }
            });
        });
        if (status == Grade.Status$.MODULE$.Published()) {
            toBeSaved.$plus$plus$eq(this.publishStack().onPublish((Iterable<CourseGrade>)published, (CourseGradeState)gradeState.elem, gradeTypes));
        }
        toBeSaved.$plus$plus$eq((IterableOnce)Operation$.MODULE$.saveOrUpdate((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{clazz, (CourseGradeState)gradeState.elem})).saveOrUpdate((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{published})).build());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])toBeSaved.toArray(ClassTag$.MODULE$.apply(Operation.class)));
        this.entityDao().execute((Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(object2));
    }

    private void updateGradeState(Grade grade, GradeState state, Project project) {
        if (grade != null && state != null) {
            if (!Objects$.MODULE$.equals(Tuple2$.MODULE$.apply((Object)grade.gradingMode(), (Object)state.gradingMode()))) {
                grade.gradingMode_$eq(state.gradingMode());
                ScoreConverter converter = this.calculator().gradeRateService().getConverter(project, state.gradingMode());
                grade.scoreText_$eq(converter.convert((Option<Object>)grade.score()));
            }
            grade.status_$eq(state.status());
            return;
        }
    }

    @Override
    public void remove(Clazz clazz, GradeType gradeType) {
        CourseGradeState state = this.getState(clazz);
        Seq<CourseGrade> courseGrades = this.getGrades(clazz);
        CourseGradeSetting gradeSetting = this.settings().getSetting(clazz.project());
        Buffer save = Collections$.MODULE$.newBuffer();
        Buffer remove = Collections$.MODULE$.newBuffer();
        Set gts = Collections$.MODULE$.newSet();
        gts.$plus$eq((Object)gradeType);
        if (GradeType$.MODULE$.EndGa() == BoxesRunTime.unboxToInt((Object)gradeType.id())) {
            gts.$plus$plus$eq(gradeSetting.gaElementTypes());
        } else if (GradeType$.MODULE$.MakeupGa() == BoxesRunTime.unboxToInt((Object)gradeType.id()) || GradeType$.MODULE$.DelayGa() == BoxesRunTime.unboxToInt((Object)gradeType.id())) {
            gts.$plus$eq((Object)new GradeType(GradeType$.MODULE$.Makeup()));
            gts.$plus$eq((Object)new GradeType(GradeType$.MODULE$.MakeupGa()));
            gts.$plus$eq((Object)new GradeType(GradeType$.MODULE$.Delay()));
            gts.$plus$eq((Object)new GradeType(GradeType$.MODULE$.DelayGa()));
        }
        courseGrades.withFilter((Function1 & Serializable)courseGrade -> BoxesRunTime.unboxToInt((Object)courseGrade.courseTakeType().id()) != CourseTakeType$.MODULE$.Exemption()).foreach((Function1 & Serializable)courseGrade -> {
            if (GradeType$.MODULE$.Final() == BoxesRunTime.unboxToInt((Object)gradeType.id())) {
                if (Grade.Status$.MODULE$.New() == courseGrade.status()) {
                    remove.$plus$eq(courseGrade);
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            if (this.removeGrade((CourseGrade)courseGrade, (Iterable<GradeType>)gts, state)) {
                return remove.$plus$eq(courseGrade);
            }
            return save.$plus$eq(courseGrade);
        });
        if (state != null) {
            if (GradeType$.MODULE$.Final() == BoxesRunTime.unboxToInt((Object)gradeType.id())) {
                state.status_$eq(Grade.Status$.MODULE$.New());
                state.examStates().clear();
                state.gaStates().clear();
            } else {
                gts.foreach((Function1 & Serializable)gt -> {
                    if (gt.isGa()) {
                        GaGradeState ggs = (GaGradeState)state.getState(gt);
                        return state.gaStates().remove((Object)ggs);
                    }
                    ExamGradeState egs = (ExamGradeState)state.getState(gt);
                    return state.examStates().remove((Object)egs);
                });
            }
        }
        Buffer buffer = state.examStates().isEmpty() && state.gaStates().isEmpty() ? (Buffer)remove.$plus$eq((Object)state) : (Buffer)save.$plus$eq((Object)state);
        this.entityDao().execute(Operation$.MODULE$.saveOrUpdate((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{save})).remove((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{remove})));
    }

    @Override
    public CourseGradeState getState(Clazz clazz) {
        return (CourseGradeState)this.entityDao().findBy(CourseGradeState.class, "clazz", (Object)clazz).headOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean removeGrade(CourseGrade courseGrade, Iterable<GradeType> gradeTypes, CourseGradeState state) {
        gradeTypes.foreach((Function1)(JProcedure1 & Serializable)gradeType -> {
            if (gradeType.isGa()) {
                GaGrade ga = (GaGrade)courseGrade.getGaGrade(gradeType).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                if (ga != null && Grade.Status$.MODULE$.New() == ga.status()) {
                    courseGrade.gaGrades().$minus$eq((Object)ga);
                    return;
                }
                return;
            }
            ExamGrade exam = (ExamGrade)courseGrade.getExamGrade(gradeType).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (exam != null && Grade.Status$.MODULE$.New() == exam.status()) {
                courseGrade.examGrades().$minus$eq((Object)exam);
                return;
            }
        });
        if (Collections$.MODULE$.isNotEmpty((Iterable)courseGrade.gaGrades()) || Collections$.MODULE$.isNotEmpty((Iterable)courseGrade.examGrades())) {
            this.calculator().calcAll(courseGrade, state);
            return false;
        }
        return true;
    }

    @Override
    public CourseGradeState getOrCreateState(Clazz clazz, Iterable<GradeType> gradeTypes, Option<Object> precision, Option<GradingMode> gradingMode) {
        ObjectRef state = ObjectRef.create((Object)this.getState(clazz));
        if ((CourseGradeState)state.elem == null) {
            CourseGradeState courseGradeState = new CourseGradeState(clazz);
            state.elem = courseGradeState;
            courseGradeState = null;
            ((CourseGradeState)state.elem).updatedAt_$eq(Instant.now());
            ((CourseGradeState)state.elem).operator_$eq(Securities$.MODULE$.user());
        }
        if (this.gradingModeStrategy() != null) {
            this.gradingModeStrategy().configGradingMode((CourseGradeState)state.elem, gradeTypes);
        }
        gradingMode.foreach((Function1)(JProcedure1 & Serializable)model -> {
            ((CourseGradeState)state$4.elem).gradingMode_$eq(model);
            GradeState es = ((CourseGradeState)state$4.elem).getState(new GradeType(GradeType$.MODULE$.EndGa()));
            if (es != null) {
                es.gradingMode_$eq(model);
                return;
            }
        });
        Option<Object> option = precision;
        if (None$.MODULE$.equals(option)) {
            if (!((CourseGradeState)state.elem).persisted() || ((CourseGradeState)state.elem).gaStates().isEmpty()) {
                ((CourseGradeState)state.elem).scorePrecision_$eq(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.projectPropertyService().get(clazz.project(), "edu.grade.score_precision", (Object)"0"))));
            }
        } else if (option instanceof Some) {
            int x = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            ((CourseGradeState)state.elem).scorePrecision_$eq(x);
        } else {
            throw new MatchError(option);
        }
        this.entityDao().saveOrUpdate((Object)((CourseGradeState)state.elem), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseGradeState[0]));
        return (CourseGradeState)state.elem;
    }

    @Override
    public List<GradeType> cleanZeroPercents(CourseGradeState gradeState, Iterable<GradeType> gradeTypes) {
        if (Collections$.MODULE$.isEmpty(gradeTypes)) {
            return package$.MODULE$.List().empty();
        }
        Buffer zeroPercentTypes = Collections$.MODULE$.newBuffer();
        gradeTypes.foreach((Function1)(JProcedure1 & Serializable)gradeType -> {
            if (!gradeType.isGa()) {
                ExamGradeState egState = (ExamGradeState)gradeState.getState(gradeType);
                if (egState == null || BoxesRunTime.equals((Object)egState.scorePercent().getOrElse(ClazzGradeServiceImpl::cleanZeroPercents$$anonfun$1$$anonfun$1), (Object)BoxesRunTime.boxToInteger((int)0))) {
                    zeroPercentTypes.addOne(gradeType);
                    gradeState.examStates().remove((Object)egState);
                    return;
                }
                return;
            }
        });
        this.entityDao().saveOrUpdate((Object)gradeState, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseGradeState[0]));
        return gradeTypes.toList().filter((Function1 & Serializable)x -> !zeroPercentTypes.contains(x));
    }

    private static final Object cleanZeroPercents$$anonfun$1$$anonfun$1() {
        return BoxesRunTime.boxToInteger((int)0);
    }
}

