/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.extern.service.signup.impl;

import java.io.Serializable;
import java.time.LocalDate;
import org.openurp.base.std.model.Student;
import org.openurp.edu.extern.code.CertificateSubject;
import org.openurp.edu.extern.config.CertSignupConfig;
import org.openurp.edu.extern.config.CertSignupSetting;
import org.openurp.edu.extern.model.CertSignup;
import org.openurp.edu.extern.service.CertificateGradeService;
import org.openurp.edu.extern.service.signup.CertSignupChecker;
import org.openurp.edu.extern.service.signup.CertSignupService;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;

public class SignupBuildInChecker
implements CertSignupChecker {
    private CertificateGradeService certificateGradeService;
    private CertSignupService examSignupService;

    public CertificateGradeService certificateGradeService() {
        return this.certificateGradeService;
    }

    public void certificateGradeService_$eq(CertificateGradeService x$1) {
        this.certificateGradeService = x$1;
    }

    public CertSignupService examSignupService() {
        return this.examSignupService;
    }

    public void examSignupService_$eq(CertSignupService x$1) {
        this.examSignupService = x$1;
    }

    @Override
    public String check(Student student, CertSignupSetting setting) {
        boolean exclusive = setting.scopes().exists((Function1 & Serializable)s -> s.matchStd(student) && !s.included());
        if (exclusive) {
            return "\u4e0d\u5728\u62a5\u540d\u8bb8\u53ef\u540d\u5355\u4e2d";
        }
        boolean inclusive = setting.scopes().exists((Function1 & Serializable)s -> s.matchStd(student) && s.included());
        if (!inclusive) {
            return "\u4e0d\u5728\u62a5\u540d\u8bb8\u53ef\u540d\u5355\u4e2d";
        }
        if (setting.dependsOn().nonEmpty() && !this.certificateGradeService().isPass(student, (CertificateSubject)setting.dependsOn().get())) {
            return "\u5c1a\u672a\u901a\u8fc7\u5148\u4fee\u79d1\u76ee";
        }
        if (setting.config().maxSubject() > 0 && this.examSignupService().get(student, setting.config()).size() >= setting.config().maxSubject()) {
            return "\u672c\u6b21\u62a5\u540d\u6700\u591a\u62a5\u540d" + setting.config().maxSubject() + "\u4e2a\u79d1\u76ee,\u5982\u9700\u62a5\u540d\uff0c\u8bf7\u53d6\u6d88\u5176\u4ed6\u79d1\u76ee\u3002";
        }
        if (this.examSignupService().get(student, setting).nonEmpty()) {
            return "\u4e0d\u80fd\u91cd\u590d\u62a5\u540d";
        }
        if (this.isTimeCollision(setting, student)) {
            return "\u8003\u8bd5\u65f6\u95f4\u51b2\u7a81";
        }
        if (!setting.reExamAllowed() && this.certificateGradeService().isPass(student, setting.subject())) {
            return setting.subject().name() + "\u5df2\u901a\u8fc7\uff0c\u65e0\u9700\u62a5\u540d";
        }
        return null;
    }

    private boolean isTimeCollision(CertSignupSetting setting, Student student) {
        Option option = setting.examOn();
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            LocalDate e = (LocalDate)((Some)option).value();
            CertSignupConfig config = setting.config();
            Iterable<CertSignup> signed = this.examSignupService().search(student, config);
            return signed.exists((Function1 & Serializable)signup -> Option$.MODULE$.option2Iterable(config.getSetting(signup.subject())).find((Function1 & Serializable)_$3 -> _$3.isTimeCollision(setting)).nonEmpty());
        }
        throw new MatchError((Object)option);
    }
}

