/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.dao.EntityDao;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.grade.config.GradeRateConfig;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class GradingModeHelper {
    private Map gradeStyles = Collections$.MODULE$.newMap();
    private Map styles = Collections$.MODULE$.newMap();
    private GradingMode defaultGradingMode;
    private EntityDao entityDao;

    public Map<String, GradingMode> gradeStyles() {
        return this.gradeStyles;
    }

    public void gradeStyles_$eq(Map<String, GradingMode> x$1) {
        this.gradeStyles = x$1;
    }

    public Map<String, GradingMode> styles() {
        return this.styles;
    }

    public void styles_$eq(Map<String, GradingMode> x$1) {
        this.styles = x$1;
    }

    public GradingMode defaultGradingMode() {
        return this.defaultGradingMode;
    }

    public void defaultGradingMode_$eq(GradingMode x$1) {
        this.defaultGradingMode = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public void init(int defaultGradingModeId) {
        Seq configs = this.entityDao().getAll(GradeRateConfig.class);
        configs.withFilter((Function1 & Serializable)config -> !config.gradingMode().numerical()).foreach((Function1)(JProcedure1 & Serializable)config -> {
            Buffer items = config.items();
            items.withFilter((Function1 & Serializable)item -> item.grade() != null).foreach((Function1 & Serializable)item -> this.gradeStyles().put((Object)item.grade(), (Object)config.gradingMode()));
        });
        Seq mss = this.entityDao().getAll(GradingMode.class);
        mss.foreach((Function1 & Serializable)style -> this.styles().put((Object)style.code(), style));
        if (defaultGradingModeId > 0) {
            this.defaultGradingMode_$eq((GradingMode)this.entityDao().get(GradingMode.class, (Object)BoxesRunTime.boxToInteger((int)defaultGradingModeId)));
            return;
        }
    }

    public GradingMode styleForCode(String code) {
        return (GradingMode)this.styles().getOrElse((Object)code, this::styleForCode$$anonfun$1);
    }

    public GradingMode styleForScore(String score) {
        Option option = this.gradeStyles().get((Object)score);
        if (None$.MODULE$.equals(option)) {
            if (Numbers$.MODULE$.isDigits(score)) {
                return this.defaultGradingMode();
            }
            return null;
        }
        if (option instanceof Some) {
            GradingMode s = (GradingMode)((Some)option).value();
            return s;
        }
        throw new MatchError((Object)option);
    }

    private final GradingMode styleForCode$$anonfun$1() {
        return this.defaultGradingMode();
    }
}

