/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.extern.service.impl;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.security.Securities$;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.code.edu.model.GradingMode$;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.extern.service.impl.ExemptionCourse;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.GaGrade;
import org.openurp.edu.grade.model.Grade;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class CourseGradeConvertor {
    private final EntityDao entityDao;
    private final CourseTakeType courseTakeType;
    private final GradeType gaGradeType;

    public CourseGradeConvertor(EntityDao entityDao) {
        this.entityDao = entityDao;
        this.courseTakeType = new CourseTakeType();
        this.courseTakeType.id_$eq((Object)BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption()));
        this.gaGradeType = (GradeType)entityDao.get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.EndGa()));
    }

    public CourseGrade convert(Student std, ExemptionCourse ec, String remark) {
        CourseGrade courseGrade;
        OqlBuilder cgQuery = OqlBuilder$.MODULE$.from(CourseGrade.class, "cg");
        cgQuery.where("cg.std=:std and cg.course=:course and cg.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std, ec.course(), ec.semester()}));
        Seq courseGrades = this.entityDao.search((QueryBuilder)cgQuery);
        if (courseGrades.isEmpty()) {
            CourseGrade cg = new CourseGrade();
            cg.project_$eq(std.project());
            cg.std_$eq(std);
            cg.crn_$eq("--");
            cg.semester_$eq(ec.semester());
            cg.course_$eq(ec.course());
            cg.createdAt_$eq(Instant.now());
            cg.courseType_$eq(ec.courseType());
            cg.examMode_$eq(ec.course().examMode());
            courseGrade = cg;
        } else {
            courseGrade = (CourseGrade)courseGrades.head();
        }
        CourseGrade courseGrade2 = courseGrade;
        OqlBuilder ctQuery = OqlBuilder$.MODULE$.from(CourseTaker.class, "ct");
        ctQuery.where("ct.std=:std and ct.course=:course and ct.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std, ec.course(), ec.semester()}));
        this.entityDao.search((QueryBuilder)ctQuery).foreach((Function1)(JProcedure1 & Serializable)taker -> {
            courseGrade2.clazz_$eq((Option)Some$.MODULE$.apply((Object)taker.clazz()));
            courseGrade2.crn_$eq(taker.clazz().crn());
            taker.takeType_$eq(this.courseTakeType);
            taker.freeListening_$eq(true);
            this.entityDao.saveOrUpdate(taker, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseTaker[0]));
        });
        courseGrade2.courseTakeType_$eq(this.courseTakeType);
        courseGrade2.gradingMode_$eq((GradingMode)ec.course().gradingModes().headOption().getOrElse(CourseGradeConvertor::convert$$anonfun$2));
        courseGrade2.freeListening_$eq(true);
        courseGrade2.passed_$eq(true);
        courseGrade2.status_$eq(Grade.Status$.MODULE$.Published());
        courseGrade2.updatedAt_$eq(Instant.now());
        courseGrade2.operator_$eq((Option)Some$.MODULE$.apply((Object)Securities$.MODULE$.user()));
        courseGrade2.updatedAt_$eq(Instant.now());
        courseGrade2.remark_$eq((Option)Some$.MODULE$.apply((Object)remark));
        GaGrade gaGrade = (GaGrade)courseGrade2.getGaGrade(this.gaGradeType).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (gaGrade == null) {
            gaGrade = new GaGrade();
            gaGrade.gradeType_$eq(this.gaGradeType);
            gaGrade.createdAt_$eq(Instant.now());
            courseGrade2.addGaGrade(gaGrade);
        }
        gaGrade.gradingMode_$eq(courseGrade2.gradingMode());
        gaGrade.scoreText_$eq(courseGrade2.scoreText());
        gaGrade.score_$eq(courseGrade2.score());
        gaGrade.passed_$eq(true);
        gaGrade.status_$eq(Grade.Status$.MODULE$.Published());
        gaGrade.gp_$eq(courseGrade2.gp());
        gaGrade.operator_$eq((Option)Some$.MODULE$.apply((Object)Securities$.MODULE$.user()));
        gaGrade.updatedAt_$eq(Instant.now());
        return courseGrade2;
    }

    private static final GradingMode convert$$anonfun$2() {
        return new GradingMode(GradingMode$.MODULE$.Percent());
    }
}

