/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.impl;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.Operation;
import org.beangle.data.dao.Operation$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.ExamStatus;
import org.openurp.code.edu.model.ExamStatus$;
import org.openurp.code.edu.model.ExamType;
import org.openurp.code.edu.model.ExamType$;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.exam.model.ExamTaker;
import org.openurp.edu.grade.BaseServiceImpl;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.CourseGradeState;
import org.openurp.edu.grade.model.ExamGrade;
import org.openurp.edu.grade.service.CourseGradePublishListener;
import org.openurp.edu.grade.service.CourseGradeSetting;
import org.openurp.edu.grade.service.CourseGradeSettings;
import org.openurp.edu.grade.service.impl.ExamTakerGeneratePublishListener$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ExamTakerGeneratePublishListener
extends BaseServiceImpl
implements CourseGradePublishListener {
    private CourseGradeSettings settings;
    private String[] forbiddenCourseNames = new String[0];
    private String[] forbiddenCourseTypeNames = new String[0];
    private String[] forbiddenCourseTakeTypeNames = new String[0];

    public CourseGradeSettings settings() {
        return this.settings;
    }

    public void settings_$eq(CourseGradeSettings x$1) {
        this.settings = x$1;
    }

    @Override
    public Seq<Operation> onPublish(Iterable<CourseGrade> grades, CourseGradeState gradeState, GradeType[] gradeTypes) {
        Buffer operations = Collections$.MODULE$.newBuffer();
        Object object = Predef$.MODULE$.refArrayOps((Object[])gradeTypes);
        boolean hasEndGa = ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)_$2 -> _$2.id().equals(BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.EndGa())));
        if (!hasEndGa) {
            return operations;
        }
        if (this.isClazzForbidden(gradeState.clazz())) {
            return operations;
        }
        CourseGradeSetting setting = this.settings().getSetting(gradeState.clazz().project());
        scala.collection.immutable.Map<Student, ExamTaker> examTakers = this.getExamTakers(gradeState.clazz());
        grades.foreach((Function1 & Serializable)grade -> (Buffer)operations.$plus$plus$eq(this.publishOneGrade((CourseGrade)grade, setting, gradeTypes, (Map<Student, ExamTaker>)examTakers)));
        return operations;
    }

    @Override
    public Seq<Operation> onPublish(CourseGrade grade, GradeType[] gradeTypes) {
        Buffer operations = Collections$.MODULE$.newBuffer();
        Object object = Predef$.MODULE$.refArrayOps((Object[])gradeTypes);
        boolean hasGa = ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)_$3 -> _$3.id().equals(BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.EndGa())));
        if (!hasGa) {
            return operations;
        }
        Clazz clazz = (Clazz)grade.clazz().get();
        if (this.isClazzForbidden(clazz)) {
            return operations;
        }
        CourseGradeSetting setting = this.settings().getSetting(clazz.project());
        scala.collection.immutable.Map<Student, ExamTaker> examTakers = this.getExamTakers(clazz, grade.std());
        operations.$plus$plus$eq(this.publishOneGrade(grade, setting, gradeTypes, (Map<Student, ExamTaker>)examTakers));
        return operations;
    }

    public boolean isClazzForbidden(Clazz clazz) {
        boolean bl;
        Object object = new Object();
        try {
            if (clazz != null) {
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.forbiddenCourseNames);
                ArrayOps$.MODULE$.withFilter$extension(object2, (Function1 & Serializable)courseName -> clazz.course().name().contains((CharSequence)courseName)).foreach((Function1 & Serializable)courseName -> {
                    throw new NonLocalReturnControl(object, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                });
                Object object3 = Predef$.MODULE$.refArrayOps((Object[])this.forbiddenCourseTypeNames);
                ArrayOps$.MODULE$.withFilter$extension(object3, (Function1 & Serializable)courseTypeName -> clazz.courseType().name().contains((CharSequence)courseTypeName)).foreach((Function1 & Serializable)courseTypeName -> {
                    throw new NonLocalReturnControl(object, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                });
            }
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = BoxesRunTime.unboxToBoolean((Object)ex.value());
            }
            throw ex;
        }
        return bl;
    }

    public boolean isCourseTakeTypeForbidden(CourseGrade grade) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.forbiddenCourseTakeTypeNames);
        return ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)_$4 -> grade.courseTakeType().name().contains((CharSequence)_$4));
    }

    public int getMakeupOrDelayExamTypeId(CourseGradeSetting setting, ExamGrade examGrade) {
        if (this.isCourseTakeTypeForbidden(examGrade.courseGrade())) {
            return 0;
        }
        ExamStatus examStatus = examGrade.examStatus();
        if (examStatus.hasDeferred()) {
            return ExamType$.MODULE$.Delay();
        }
        if (setting.allowExamStatuses().contains((Object)examStatus)) {
            return ExamType$.MODULE$.Makeup();
        }
        return 0;
    }

    private scala.collection.immutable.Map<Student, ExamTaker> getExamTakers(Clazz clazz) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(ExamTaker.class, "examTaker");
        builder.where("examTaker.clazz=:clazz and examTaker.examType in (:examTypes)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz, new ExamType[]{ExamTakerGeneratePublishListener$.org$openurp$edu$grade$service$impl$ExamTakerGeneratePublishListener$$$Makeup, ExamTakerGeneratePublishListener$.org$openurp$edu$grade$service$impl$ExamTakerGeneratePublishListener$$$Delay}}));
        scala.collection.immutable.Seq examTakers = this.entityDao().search((QueryBuilder)builder);
        return ((IterableOnceOps)examTakers.map((Function1 & Serializable)t -> Tuple2$.MODULE$.apply((Object)t.std(), t))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private scala.collection.immutable.Map<Student, ExamTaker> getExamTakers(Clazz clazz, Student std) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(ExamTaker.class, "examTaker");
        builder.where("examTaker.std=:std and examTaker.clazz=:clazz and examTaker.examType in (:examTypes) and examTaker.activity is null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std, clazz, new ExamType[]{ExamTakerGeneratePublishListener$.org$openurp$edu$grade$service$impl$ExamTakerGeneratePublishListener$$$Makeup, ExamTakerGeneratePublishListener$.org$openurp$edu$grade$service$impl$ExamTakerGeneratePublishListener$$$Delay}}));
        scala.collection.immutable.Seq examTakers = this.entityDao().search((QueryBuilder)builder);
        return ((IterableOnceOps)examTakers.map((Function1 & Serializable)t -> Tuple2$.MODULE$.apply((Object)t.std(), t))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Seq<Operation> publishOneGrade(CourseGrade grade, CourseGradeSetting setting, GradeType[] gradeTypes, Map<Student, ExamTaker> examTakers) {
        Buffer operations = Collections$.MODULE$.newBuffer();
        ExamGrade examGrade = (ExamGrade)grade.getExamGrade(new GradeType(GradeType$.MODULE$.End())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (examGrade == null) {
            return operations;
        }
        Clazz clazz = (Clazz)grade.clazz().get();
        Student std = grade.std();
        ExamTaker taker = null;
        if (!grade.passed()) {
            int examTypeId = this.getMakeupOrDelayExamTypeId(setting, examGrade);
            if (examTypeId > 0) {
                taker = this.getOrCreateExamTaker(std, clazz, new ExamType(examTypeId), examTakers);
            }
            if (taker == null) {
                this.addRemoveExamTakers((Buffer<Operation>)operations, std, examTakers, (scala.collection.immutable.Seq<ExamType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExamType[]{ExamTakerGeneratePublishListener$.org$openurp$edu$grade$service$impl$ExamTakerGeneratePublishListener$$$Makeup, ExamTakerGeneratePublishListener$.org$openurp$edu$grade$service$impl$ExamTakerGeneratePublishListener$$$Delay}));
            } else {
                operations.$plus$plus$eq((IterableOnce)Operation$.MODULE$.saveOrUpdate((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{taker})).build());
                ExamType examType = taker.examType();
                ExamType examType2 = ExamTakerGeneratePublishListener$.org$openurp$edu$grade$service$impl$ExamTakerGeneratePublishListener$$$Makeup;
                if (!(examType != null ? !examType.equals(examType2) : examType2 != null)) {
                    this.addRemoveExamTakers((Buffer<Operation>)operations, std, examTakers, (scala.collection.immutable.Seq<ExamType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExamType[]{ExamTakerGeneratePublishListener$.org$openurp$edu$grade$service$impl$ExamTakerGeneratePublishListener$$$Delay}));
                }
                ExamType examType3 = taker.examType();
                ExamType examType4 = ExamTakerGeneratePublishListener$.org$openurp$edu$grade$service$impl$ExamTakerGeneratePublishListener$$$Delay;
                if (!(examType3 != null ? !examType3.equals(examType4) : examType4 != null)) {
                    this.addRemoveExamTakers((Buffer<Operation>)operations, std, examTakers, (scala.collection.immutable.Seq<ExamType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExamType[]{ExamTakerGeneratePublishListener$.org$openurp$edu$grade$service$impl$ExamTakerGeneratePublishListener$$$Makeup}));
                }
            }
        } else {
            if (grade.getExamGrade(new GradeType(GradeType$.MODULE$.Delay())) != null) {
                this.addRemoveExamTakers((Buffer<Operation>)operations, std, examTakers, (scala.collection.immutable.Seq<ExamType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExamType[]{ExamTakerGeneratePublishListener$.org$openurp$edu$grade$service$impl$ExamTakerGeneratePublishListener$$$Makeup}));
            }
            if (grade.getGrade(new GradeType(GradeType$.MODULE$.MakeupGa())) != null) {
                this.addRemoveExamTakers((Buffer<Operation>)operations, std, examTakers, (scala.collection.immutable.Seq<ExamType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExamType[]{ExamTakerGeneratePublishListener$.org$openurp$edu$grade$service$impl$ExamTakerGeneratePublishListener$$$Delay}));
            }
        }
        return operations;
    }

    private void addRemoveExamTakers(Buffer<Operation> operations, Student std, Map<Student, ExamTaker> examTakers, scala.collection.immutable.Seq<ExamType> examTypes) {
        examTakers.get((Object)std).foreach((Function1)(JProcedure1 & Serializable)taker -> examTypes.withFilter((Function1 & Serializable)examType -> {
            ExamType examType2 = taker.examType();
            ExamType examType3 = examType;
            return !(examType2 != null ? !examType2.equals(examType3) : examType3 != null);
        }).foreach((Function1 & Serializable)examType -> (Buffer)operations.$plus$plus$eq((IterableOnce)Operation$.MODULE$.remove((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{taker})).build())));
    }

    private ExamTaker getOrCreateExamTaker(Student std, Clazz clazz, ExamType examType, Map<Student, ExamTaker> examTakers) {
        Option option = examTakers.get((Object)std);
        if (None$.MODULE$.equals(option)) {
            ExamTaker taker = new ExamTaker();
            taker.std_$eq(std);
            taker.clazz_$eq(clazz);
            taker.semester_$eq(clazz.semester());
            taker.examType_$eq(examType);
            taker.examStatus_$eq(new ExamStatus(ExamStatus$.MODULE$.Normal()));
            return taker;
        }
        if (option instanceof Some) {
            ExamTaker taker = (ExamTaker)((Some)option).value();
            return taker;
        }
        throw new MatchError((Object)option);
    }

    public void setForbiddenCourseNames(String names) {
        this.forbiddenCourseNames = Strings$.MODULE$.split(names, ",");
        if (this.forbiddenCourseNames == null) {
            this.forbiddenCourseNames = new String[0];
            return;
        }
    }

    public void setForbiddenCourseTypeNames(String names) {
        this.forbiddenCourseTypeNames = Strings$.MODULE$.split(names, ",");
        if (this.forbiddenCourseTypeNames == null) {
            this.forbiddenCourseTypeNames = new String[0];
            return;
        }
    }

    public void setForbiddenCourseTakeTypeNames(String names) {
        this.forbiddenCourseTakeTypeNames = Strings$.MODULE$.split(names, ",");
        if (this.forbiddenCourseTakeTypeNames == null) {
            this.forbiddenCourseTakeTypeNames = new String[0];
            return;
        }
    }
}

