/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.impl;

import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Order$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.service.StdGradeService;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class StdGradeServiceImpl
implements StdGradeService {
    private EntityDao entityDao;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    @Override
    public Student stdByCode(String stdCode, Project project, List<Department> departments, EntityDao entityDao) {
        OqlBuilder oqlBuilder;
        OqlBuilder query = OqlBuilder$.MODULE$.from(Student.class, "std");
        query.where("std.code=:code", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{stdCode}));
        if (project == null || Collections$.MODULE$.isEmpty(departments)) {
            oqlBuilder = (OqlBuilder)query.where("std is null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        } else {
            query.where("std.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
            oqlBuilder = (OqlBuilder)query.where("std.state.department in (:departments)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departments}));
        }
        Seq stds = entityDao.search((QueryBuilder)query);
        if (Collections$.MODULE$.isEmpty((Iterable)stds)) {
            return null;
        }
        if (stds.size() == 1) {
            return (Student)stds.head();
        }
        throw new RuntimeException("\u6570\u636e\u5f02\u5e38");
    }

    @Override
    public OqlBuilder<GradeType> buildGradeTypeQuery() {
        OqlBuilder query = OqlBuilder$.MODULE$.from(GradeType.class, "gradeType");
        query.where("gradeType.id not in (:ids)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new int[]{GradeType$.MODULE$.Final()}}));
        query.where("gradeType.beginOn <= :now and (gradeType.endOn is null or gradeType.endOn >= :now)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        query.orderBy(Order$.MODULE$.parse("gradeType.code asc"));
        return query;
    }

    @Override
    public Object[] getStatus(String crn, String stdId, String semesterId, EntityDao entityDao) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseTaker.class, "taker");
        query.where("taker.clazz.crn = :crn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{crn}));
        query.where("taker.std.id = :stdId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Numbers$.MODULE$.toLong(stdId, Numbers$.MODULE$.toLong$default$2()))}));
        query.where("not exists(from " + CourseGrade.class.getName() + " grade where grade.std.id = :stdId and grade.clazz.crn=:crn)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Numbers$.MODULE$.toLong(stdId, Numbers$.MODULE$.toLong$default$2())), crn}));
        query.where("taker.clazz.semester.id = :semesterId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Numbers$.MODULE$.toInt(semesterId, Numbers$.MODULE$.toInt$default$2()))}));
        query.select("taker.clazz.id,taker.clazz.course.code,taker.clazz.course.name,taker.clazz.gradeState.gradingMode.id,taker.clazz.gradeState.gradingMode.name");
        Seq takers = entityDao.search((QueryBuilder)query);
        if (Collections$.MODULE$.isEmpty((Iterable)takers)) {
            return null;
        }
        if (takers.size() == 1) {
            return (Object[])takers.head();
        }
        throw new RuntimeException("\u6570\u636e\u5f02\u5e38");
    }

    @Override
    public boolean checkStdGradeExists(Student std, Semester semester, Course course, Project project) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(CourseGrade.class, "courseGrade");
        builder.where("courseGrade.semester = :semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        builder.where("courseGrade.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        builder.where("courseGrade.std = :student", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        builder.where("courseGrade.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        return this.entityDao().search((QueryBuilder)builder).nonEmpty();
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao_$eq(entityDao);
    }
}

