/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.finalmakeup.service.impl;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.LongId;
import org.openurp.base.edu.code.CourseType;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.Department;
import org.openurp.base.model.Semester;
import org.openurp.base.std.model.Squad;
import org.openurp.base.std.model.Student;
import org.openurp.base.std.model.StudentState;
import org.openurp.edu.exam.model.FinalMakeupCourse;
import org.openurp.edu.exam.model.FinalMakeupTaker;
import org.openurp.edu.finalmakeup.service.MakeupCourseCrnGenerator;
import org.openurp.edu.finalmakeup.service.MakeupCourseService;
import org.openurp.edu.grade.model.CourseAuditResult;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class MakeupCourseServiceImpl
implements MakeupCourseService {
    private EntityDao entityDao;
    private MakeupCourseCrnGenerator crnGenerator;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public MakeupCourseCrnGenerator crnGenerator() {
        return this.crnGenerator;
    }

    public void crnGenerator_$eq(MakeupCourseCrnGenerator x$1) {
        this.crnGenerator = x$1;
    }

    @Override
    public Seq<FinalMakeupCourse> split(FinalMakeupCourse makeupCourse) {
        if (Collections$.MODULE$.isNotEmpty((Iterable)makeupCourse.squads())) {
            Buffer newMcs = Collections$.MODULE$.newBuffer();
            makeupCourse.squads().foreach((Function1)(JProcedure1 & Serializable)squad -> {
                FinalMakeupCourse newMc = new FinalMakeupCourse();
                newMc.squads().$plus$eq(squad);
                newMc.course_$eq(makeupCourse.course());
                newMc.depart_$eq(makeupCourse.depart());
                newMc.semester_$eq(makeupCourse.semester());
                makeupCourse.takers().foreach((Function1)(JProcedure1 & Serializable)taker -> {
                    if (BoxesRunTime.equals((Object)squad.id(), (Object)taker.std().state().map((Function1 & Serializable)_$3 -> _$3.squad().map((Function1 & Serializable)_$4 -> BoxesRunTime.unboxToLong((Object)_$4.id()))).getOrElse(MakeupCourseServiceImpl::split$$anonfun$1$$anonfun$1$$anonfun$2))) {
                        newMc.takers().$plus$eq((Object)new FinalMakeupTaker(newMc, taker.std(), taker.courseType()));
                        return;
                    }
                });
                newMc.stdCount_$eq(newMc.takers().size());
                this.crnGenerator().gen(newMc);
                newMcs.$plus$eq((Object)newMc);
                this.entityDao().saveOrUpdate((Object)newMc, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FinalMakeupCourse[0]));
            });
            this.entityDao().remove((Object)makeupCourse, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FinalMakeupCourse[0]));
            return newMcs.toSeq();
        }
        return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FinalMakeupCourse[]{makeupCourse}));
    }

    @Override
    public String addTaker(FinalMakeupCourse makeupCourse, Student std) {
        Option<CourseAuditResult> result = this.getCourseResult(std, makeupCourse.course());
        if (result.isEmpty()) {
            return "\u6ca1\u6709\u4e0d\u53ca\u683c\u6210\u7ee9\uff0c\u65e0\u9700\u8865\u8003";
        }
        Option<FinalMakeupTaker> existed = this.getTaker(makeupCourse.semester(), makeupCourse.course(), std);
        if (existed.isDefined()) {
            return "\u5df2\u7ecf\u5728" + ((FinalMakeupTaker)Option$.MODULE$.option2Iterable(existed).head()).makeupCourse().crn() + "\u4e2d,\u65e0\u9700\u91cd\u590d\u6dfb\u52a0";
        }
        return this.doAddTaker(makeupCourse, std, result);
    }

    private Option<CourseAuditResult> getCourseResult(Student std, Course course) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(CourseAuditResult.class, "courseResult");
        builder.where("courseResult.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        builder.where("courseResult.groupResult.planResult.std=:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        return this.entityDao().search((QueryBuilder)builder).headOption();
    }

    private Option<FinalMakeupTaker> getTaker(Semester semester, Course course, Student std) {
        OqlBuilder query = (OqlBuilder)OqlBuilder$.MODULE$.from(FinalMakeupTaker.class, "mt").where("mt.makeupCourse.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester})).where("mt.makeupCourse.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course})).where("mt.std=:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    private String doAddTaker(FinalMakeupCourse makeupCourse, Student std, Option<CourseAuditResult> result) {
        result.foreach((Function1)(JProcedure1 & Serializable)r -> {
            CourseType courseType = r.groupResult().courseType();
            FinalMakeupTaker take = new FinalMakeupTaker(makeupCourse, std, courseType);
            take.scores_$eq(r.scores());
            take.remark_$eq(r.remark());
            makeupCourse.takers().$plus$eq((Object)take);
            makeupCourse.stdCount_$eq(makeupCourse.stdCount() + 1);
            this.entityDao().saveOrUpdate((Object)makeupCourse, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LongId[]{take}));
        });
        return "";
    }

    @Override
    public String addTaker(Semester semester, Course course, Student std) {
        Option<CourseAuditResult> result = this.getCourseResult(std, course);
        if (result.isEmpty()) {
            return "\u6ca1\u6709\u4e0d\u53ca\u683c\u6210\u7ee9\uff0c\u65e0\u9700\u8865\u8003";
        }
        FinalMakeupCourse makeupCourse = this.getOrCreate(semester, course, ((StudentState)std.state().get()).department(), (Option<Squad>)((StudentState)std.state().get()).squad());
        Option<FinalMakeupTaker> existed = this.getTaker(makeupCourse.semester(), makeupCourse.course(), std);
        if (existed.isDefined()) {
            return "\u5df2\u7ecf\u5728" + ((FinalMakeupTaker)Option$.MODULE$.option2Iterable(existed).head()).makeupCourse().crn() + "\u4e2d,\u65e0\u9700\u91cd\u590d\u6dfb\u52a0";
        }
        return this.doAddTaker(makeupCourse, std, result);
    }

    @Override
    public FinalMakeupCourse getOrCreate(Semester semester, Course course, Department department, Option<Squad> squad) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(FinalMakeupCourse.class, "makeupCourse");
        builder.where("makeupCourse.semester = :semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        builder.where("makeupCourse.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        Option<Squad> option = squad;
        if (None$.MODULE$.equals(option)) {
            v0 = (OqlBuilder)builder.where("size(makeupCourse.squads)=0", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        } else if (option instanceof Some) {
            Squad s = (Squad)((Some)option).value();
            v0 = (OqlBuilder)builder.where(":squad in elements(makeupCourse.squads)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{s}));
        } else {
            throw new MatchError(option);
        }
        Seq makeupCourses = this.entityDao().search((QueryBuilder)builder);
        if (Collections$.MODULE$.isEmpty((Iterable)makeupCourses)) {
            FinalMakeupCourse makeupCourse = new FinalMakeupCourse();
            makeupCourse.semester_$eq(semester);
            makeupCourse.course_$eq(course);
            makeupCourse.depart_$eq(department);
            makeupCourse.project_$eq(course.project());
            squad.foreach((Function1 & Serializable)_$5 -> (Set)makeupCourse.squads().$plus$eq(_$5));
            this.crnGenerator().gen(makeupCourse);
            this.entityDao().saveOrUpdate((Object)makeupCourse, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FinalMakeupCourse[0]));
            return makeupCourse;
        }
        return (FinalMakeupCourse)makeupCourses.head();
    }

    private static final Object split$$anonfun$1$$anonfun$1$$anonfun$2() {
        return BoxesRunTime.boxToInteger((int)0);
    }
}

