/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.impl;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.domain.GroupResultAdapter;
import org.openurp.edu.grade.model.CourseAuditResult;
import org.openurp.edu.grade.model.GroupAuditResult;
import org.openurp.edu.grade.model.PlanAuditResult;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class PlanAuditPersister$
implements Logging,
Serializable {
    private static Logger logger;
    public static final PlanAuditPersister$ MODULE$;

    private PlanAuditPersister$() {
    }

    static {
        MODULE$ = new PlanAuditPersister$();
        Logging.$init$((Logging)MODULE$);
        Statics.releaseFence();
    }

    public Logger logger() {
        return logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PlanAuditPersister$.class);
    }

    public void save(PlanAuditResult newResult, EntityDao entityDao) {
        PlanAuditResult existedResult = (PlanAuditResult)this.result(newResult.std(), entityDao).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (existedResult != null) {
            existedResult.remark_$eq(newResult.remark());
            existedResult.updatedAt_$eq(Instant.now());
            float existedCreditsCompleted = existedResult.auditStat().passedCredits();
            existedResult.auditStat_$eq(newResult.auditStat());
            boolean updatePassed = true;
            boolean existedPassed = existedResult.passed();
            if (!existedResult.archived()) {
                updatePassed = false;
                if (existedResult.passed() && newResult.auditStat().passedCredits() < existedCreditsCompleted) {
                    updatePassed = true;
                }
            }
            StringBuilder updates = new StringBuilder();
            this.mergeGroupResult(existedResult, (GroupAuditResult)new GroupResultAdapter(existedResult), (GroupAuditResult)new GroupResultAdapter(newResult), updates);
            if (!updatePassed) {
                existedResult.passed_$eq(existedPassed);
            } else {
                existedResult.passed_$eq(newResult.passed());
            }
            if (updates.nonEmpty()) {
                updates.deleteCharAt(updates.length() - 1);
            }
            existedResult.updates_$eq((Option)Some$.MODULE$.apply((Object)updates.toString()));
        } else {
            existedResult = newResult;
        }
        entityDao.saveOrUpdate((Object)existedResult, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PlanAuditResult[0]));
    }

    private Option<PlanAuditResult> result(Student std, EntityDao entityDao) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(PlanAuditResult.class, "planResult");
        query.where("planResult.std = :std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        return entityDao.search((QueryBuilder)query).headOption();
    }

    private void mergeGroupResult(PlanAuditResult existedResult, GroupAuditResult target, GroupAuditResult source, StringBuilder updates) {
        float delta = source.auditStat().passedCredits() - target.auditStat().passedCredits();
        if (Float.compare(delta, 0.0f) != 0) {
            updates.append(source.name());
            StringBuilder stringBuilder = delta > 0.0f ? updates.append('+').append(delta) : updates.append(delta);
            updates.append(';');
        }
        target.auditStat_$eq(source.auditStat());
        target.passed_$eq(source.passed());
        target.indexno_$eq(source.indexno());
        Map tarGroupResults = Collections$.MODULE$.newMap();
        Map sourceGroupResults = Collections$.MODULE$.newMap();
        target.children().foreach((Function1 & Serializable)result -> tarGroupResults.put((Object)result.name(), result));
        source.children().foreach((Function1 & Serializable)result -> sourceGroupResults.put((Object)result.name(), result));
        Map tarCourseResults = Collections$.MODULE$.newMap();
        Map sourceCourseResults = Collections$.MODULE$.newMap();
        target.courseResults().foreach((Function1 & Serializable)courseResult -> tarCourseResults.put((Object)courseResult.course(), courseResult));
        source.courseResults().foreach((Function1 & Serializable)courseResult -> sourceCourseResults.put((Object)courseResult.course(), courseResult));
        List removed = Collections$.MODULE$.subtract((Iterable)tarGroupResults.keySet(), (Iterable)sourceGroupResults.keySet());
        removed.foreach((Function1)(JProcedure1 & Serializable)groupName -> {
            GroupAuditResult gg = (GroupAuditResult)tarGroupResults.apply(groupName);
            gg.detach();
            target.removeChild(gg);
        });
        List added = Collections$.MODULE$.subtract((Iterable)sourceGroupResults.keySet(), (Iterable)tarGroupResults.keySet());
        added.foreach((Function1)(JProcedure1 & Serializable)groupName -> {
            GroupAuditResult groupResult = (GroupAuditResult)sourceGroupResults.get(groupName);
            target.addChild(groupResult);
            groupResult.attachTo(existedResult);
        });
        List common = Collections$.MODULE$.intersection((Iterable)sourceGroupResults.keySet(), (Iterable)tarGroupResults.keySet());
        common.foreach((Function1)(JProcedure1 & Serializable)groupName -> this.mergeGroupResult(existedResult, (GroupAuditResult)tarGroupResults.apply(groupName), (GroupAuditResult)sourceGroupResults.apply(groupName), updates));
        List removedCourses = Collections$.MODULE$.subtract((Iterable)tarCourseResults.keySet(), (Iterable)sourceCourseResults.keySet());
        removedCourses.foreach((Function1 & Serializable)course -> {
            CourseAuditResult courseResult = (CourseAuditResult)tarCourseResults.apply(course);
            return (Buffer)target.courseResults().$minus$eq((Object)courseResult);
        });
        List addedCourses = Collections$.MODULE$.subtract((Iterable)sourceCourseResults.keySet(), (Iterable)tarCourseResults.keySet());
        addedCourses.foreach((Function1 & Serializable)course -> {
            CourseAuditResult courseResult = (CourseAuditResult)sourceCourseResults.apply(course);
            courseResult.groupResult().courseResults().$minus$eq((Object)courseResult);
            courseResult.groupResult_$eq(target);
            return (Buffer)target.courseResults().$plus$eq((Object)courseResult);
        });
        List commonCourses = Collections$.MODULE$.intersection((Iterable)sourceCourseResults.keySet(), (Iterable)tarCourseResults.keySet());
        commonCourses.foreach((Function1)(JProcedure1 & Serializable)course -> {
            CourseAuditResult targetCourseResult = (CourseAuditResult)tarCourseResults.apply(course);
            CourseAuditResult sourceCourseResult = (CourseAuditResult)sourceCourseResults.apply(course);
            targetCourseResult.passed_$eq(sourceCourseResult.passed());
            targetCourseResult.scores_$eq(sourceCourseResult.scores());
            targetCourseResult.compulsory_$eq(sourceCourseResult.compulsory());
            targetCourseResult.remark_$eq(sourceCourseResult.remark());
        });
    }
}

