/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exempt.service.impl;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.AuditStatus$;
import org.openurp.code.edu.model.ExamStatus;
import org.openurp.code.edu.model.ExamStatus$;
import org.openurp.edu.exempt.model.CertExemptApply;
import org.openurp.edu.exempt.service.CertExemptApplyService;
import org.openurp.edu.exempt.service.ExemptionService;
import org.openurp.edu.extern.model.CertificateGrade;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class CertExemptApplyServiceImpl
implements CertExemptApplyService {
    private EntityDao entityDao;
    private ExemptionService exemptionService;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public ExemptionService exemptionService() {
        return this.exemptionService;
    }

    public void exemptionService_$eq(ExemptionService x$1) {
        this.exemptionService = x$1;
    }

    @Override
    public void accept(CertExemptApply apply) {
        CertificateGrade grade = this.convert(apply);
        this.entityDao().saveOrUpdate((Object)grade, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertificateGrade[0]));
        this.exemptionService().addExemption(grade, (Iterable<Course>)grade.exempts());
        apply.status_$eq(AuditStatus$.Passed);
        this.entityDao().saveOrUpdate((Object)apply, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertExemptApply[0]));
    }

    @Override
    public void reject(CertExemptApply apply) {
        CertificateGrade grade = this.convert(apply);
        if (grade.persisted()) {
            this.entityDao().remove((Object)grade, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertificateGrade[0]));
        }
        grade.exempts().foreach((Function1)(JProcedure1 & Serializable)c -> this.exemptionService().removeExemption(grade, (Course)c));
        apply.status_$eq(AuditStatus$.Rejected);
        this.entityDao().saveOrUpdate((Object)apply, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertExemptApply[0]));
    }

    private CertificateGrade convert(CertExemptApply apply) {
        CertificateGrade certificateGrade;
        OqlBuilder query = OqlBuilder$.MODULE$.from(CertificateGrade.class, "cg");
        query.where("cg.std = :std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{apply.std()}));
        query.where("cg.subject = :subject", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{apply.subject()}));
        query.where("cg.acquiredOn = :acquiredOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{apply.acquiredOn()}));
        Seq grades = this.entityDao().search((QueryBuilder)query);
        Option option = grades.headOption();
        if (None$.MODULE$.equals(option)) {
            CertificateGrade g = new CertificateGrade();
            g.std_$eq(apply.std());
            g.subject_$eq(apply.subject());
            g.acquiredOn_$eq(apply.acquiredOn());
            certificateGrade = g;
        } else if (option instanceof Some) {
            CertificateGrade g;
            certificateGrade = g = (CertificateGrade)((Some)option).value();
        } else {
            throw new MatchError((Object)option);
        }
        CertificateGrade grade = certificateGrade;
        grade.scoreText_$eq(apply.scoreText());
        if (Numbers$.MODULE$.isDigits(apply.scoreText())) {
            grade.score_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Numbers$.MODULE$.toFloat(apply.scoreText(), Numbers$.MODULE$.toFloat$default$2()))));
        }
        grade.passed_$eq(true);
        grade.certificate_$eq(apply.certificate());
        grade.status_$eq(2);
        grade.examStatus_$eq(new ExamStatus(ExamStatus$.MODULE$.Normal()));
        grade.exempts().$plus$plus$eq((IterableOnce)apply.courses());
        grade.gradingMode_$eq(apply.gradingMode());
        grade.updatedAt_$eq(Instant.now());
        return grade;
    }
}

