/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exempt.service.impl;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.edu.code.CourseType;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.Semester;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.ExternStudent;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.edu.exempt.service.ExemptionService;
import org.openurp.edu.exempt.service.impl.CourseGradeConvertor;
import org.openurp.edu.exempt.service.impl.ExemptionCourse$;
import org.openurp.edu.extern.model.CertificateGrade;
import org.openurp.edu.extern.model.ExternGrade;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.Grade;
import org.openurp.edu.program.domain.CoursePlanProvider;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.Program;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class ExemptionServiceImpl
implements ExemptionService {
    private EntityDao entityDao;
    private SemesterService semesterService;
    private CoursePlanProvider coursePlanProvider;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public CoursePlanProvider coursePlanProvider() {
        return this.coursePlanProvider;
    }

    public void coursePlanProvider_$eq(CoursePlanProvider x$1) {
        this.coursePlanProvider = x$1;
    }

    @Override
    public Option<Semester> getSemester(Program program, Option<Object> term) {
        Option<Object> option = term;
        if (option instanceof Some) {
            int t = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return this.semesterService().get(program.project(), program.beginOn(), program.endOn(), t);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    @Override
    public Seq<PlanCourse> getConvertablePlanCourses(Student std, CoursePlan plan) {
        Map coursesMap = Collections$.MODULE$.newMap();
        plan.planCourses().foreach((Function1 & Serializable)pc -> coursesMap.put((Object)pc.course(), pc));
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseGrade.class, "cg");
        query.where("cg.std=:std and cg.status=:status", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std, BoxesRunTime.boxToInteger((int)Grade.Status$.MODULE$.Published())}));
        Seq courseGrades = this.entityDao().search((QueryBuilder)query);
        courseGrades.foreach((Function1)(JProcedure1 & Serializable)courseGrade -> {
            if (courseGrade.passed()) {
                coursesMap.remove((Object)courseGrade.course());
                return;
            }
        });
        coursesMap.filterInPlace((Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                PlanCourse pc = (PlanCourse)tuple2._2();
                return pc.terms().termList().nonEmpty() && this.semesterService().get(std.project(), std.beginOn(), std.endOn(), BoxesRunTime.unboxToInt((Object)pc.terms().termList().head())).nonEmpty();
            }
            throw new MatchError((Object)tuple2);
        });
        return coursesMap.values().toSeq();
    }

    @Override
    public Seq<CourseGrade> getConvertedGrades(Student std, Iterable<Course> courses) {
        if (courses.isEmpty()) {
            return package$.MODULE$.List().empty();
        }
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(CourseGrade.class, "cg");
        query2.where("cg.std=:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query2.where("cg.course in(:courses)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{courses}));
        query2.where("cg.courseTakeType.id=:exemption", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption())}));
        return this.entityDao().search((QueryBuilder)query2);
    }

    @Override
    public void removeExemption(ExternGrade eg, Course course) {
        eg.exempts().subtractOne((Object)course);
        this.entityDao().saveOrUpdate((Object)eg, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExternGrade[0]));
        ExternStudent es = eg.externStudent();
        this.removeExemption(es.std(), course);
        this.entityDao().saveOrUpdate((Object)eg, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExternGrade[0]));
    }

    private void removeExemption(Student std, Course course) {
        Iterable<CourseGrade> cgs = this.getExemptionGrades(std, course);
        if (cgs.size() > 1) {
            throw new RuntimeException("found " + cgs.size() + " exemption grades of " + std.code());
        }
        this.entityDao().remove(cgs);
    }

    @Override
    public void removeExemption(CertificateGrade cg, Course course) {
        cg.exempts().subtractOne((Object)course);
        this.entityDao().saveOrUpdate((Object)cg, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertificateGrade[0]));
        this.removeExemption(cg.std(), course);
        this.entityDao().saveOrUpdate((Object)cg, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertificateGrade[0]));
    }

    @Override
    public void addExemption(ExternGrade eg, Iterable<Course> courses) {
        String remark = eg.externStudent().school().name() + " " + eg.courseName() + " " + eg.scoreText();
        Student std = eg.externStudent().std();
        this.addCourseGrades(std, courses, remark);
        Set emptyCourses = (Set)eg.exempts().filter((Function1 & Serializable)x -> this.getExemptionGrades(std, (Course)x).isEmpty());
        eg.exempts().subtractAll((IterableOnce)emptyCourses);
        eg.exempts().$plus$plus$eq(courses);
        this.entityDao().saveOrUpdate((Object)eg, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExternGrade[0]));
    }

    @Override
    public void addExemption(CertificateGrade cg, Iterable<Course> courses) {
        String remark = cg.subject().name() + " " + cg.scoreText();
        Student std = cg.std();
        this.addCourseGrades(std, courses, remark);
        Set emptyCourses = (Set)cg.exempts().filter((Function1 & Serializable)x -> this.getExemptionGrades(std, (Course)x).isEmpty());
        cg.exempts().subtractAll((IterableOnce)emptyCourses);
        cg.exempts().$plus$plus$eq(courses);
        this.entityDao().saveOrUpdate((Object)cg, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertificateGrade[0]));
    }

    private Iterable<CourseGrade> getExemptionGrades(Student std, Course course) {
        OqlBuilder cgQuery = OqlBuilder$.MODULE$.from(CourseGrade.class, "cg");
        cgQuery.where("cg.std=:std and cg.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std, course}));
        cgQuery.where("cg.courseTakeType.id=:exemption", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption())}));
        return this.entityDao().search((QueryBuilder)cgQuery);
    }

    private void addCourseGrades(Student std, Iterable<Course> courses, String remark) {
        OqlBuilder cgQuery = OqlBuilder$.MODULE$.from(CourseGrade.class, "cg");
        cgQuery.where("cg.std=:std and cg.courseTakeType.id=:exemptionTypeId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std, BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption())}));
        cgQuery.where("cg.remark=:remark", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{remark}));
        Seq exemptGrades = this.entityDao().search((QueryBuilder)cgQuery);
        scala.collection.immutable.Set courseSet = courses.toSet();
        this.entityDao().remove((Iterable)exemptGrades.filter((Function1 & Serializable)x -> !courseSet.contains((Object)x.course())));
        CourseGradeConvertor convertor = new CourseGradeConvertor(this.entityDao());
        courses.foreach((Function1)(JProcedure1 & Serializable)c -> {
            ObjectRef semester = ObjectRef.create(null);
            ObjectRef courseType = ObjectRef.create(null);
            this.coursePlanProvider().getPlanCourse(std, c).foreach((Function1)(JProcedure1 & Serializable)pc -> {
                CourseType courseType = pc.group().courseType();
                courseType$1.elem = courseType;
                courseType = null;
                pc.terms().termList().headOption().foreach((Function1)(JFunction1.mcVI.sp & Serializable)term -> this.coursePlanProvider().getCoursePlan(std).foreach((Function1)(JProcedure1 & Serializable)plan -> {
                    Program program = plan.program();
                    Semester semester = (Semester)this.semesterService().get(std.project(), program.beginOn(), program.endOn(), term).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    semester$3.elem = semester;
                    semester = null;
                }));
            });
            if ((Semester)semester.elem == null) {
                Semester semester2 = this.semesterService().get(std.project(), LocalDate.now());
                semester.elem = semester2;
                semester2 = null;
            }
            if ((CourseType)courseType.elem == null) {
                CourseType courseType2 = c.courseType();
                courseType.elem = courseType2;
                courseType2 = null;
            }
            CourseGrade grade = convertor.convert(std, ExemptionCourse$.MODULE$.apply((Course)c, (CourseType)courseType.elem, (Semester)semester.elem), remark);
            this.entityDao().saveOrUpdate((Object)grade, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseGrade[0]));
        });
    }
}

