/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.HashMap;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.script.ExpressionEvaluator;
import org.openurp.edu.grade.config.GradeRateConfig;
import org.openurp.edu.grade.config.GradeRateItem;
import scala.Float$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.collection.mutable.Map;
import scala.runtime.BoxesRunTime;

public class ScoreConverter {
    private GradeRateConfig config;
    private ExpressionEvaluator expressionEvaluator;
    private final Map<String, Object> defaultScoreMap;

    public ScoreConverter(GradeRateConfig config, ExpressionEvaluator expressionEvaluator) {
        this.config = config;
        this.expressionEvaluator = expressionEvaluator;
        this.defaultScoreMap = Collections$.MODULE$.newMap();
        if (this.config() != null) {
            for (GradeRateItem item : this.config().items()) {
                this.defaultScoreMap.put((Object)item.grade(), (Object)BoxesRunTime.boxToFloat((float)item.defaultScore()));
            }
        }
    }

    private GradeRateConfig config() {
        return this.config;
    }

    private void config_$eq(GradeRateConfig x$0) {
        this.config = x$0;
    }

    private ExpressionEvaluator expressionEvaluator() {
        return this.expressionEvaluator;
    }

    private void expressionEvaluator_$eq(ExpressionEvaluator x$0) {
        this.expressionEvaluator = x$0;
    }

    public Option<String> convert(Option<Object> score) {
        Option<Object> option = score;
        if (option == null) {
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            float s = BoxesRunTime.unboxToFloat((Object)((Some)option).value());
            if (this.config() == null) {
                return Option$.MODULE$.apply((Object)NumberFormat.getInstance().format(Float$.MODULE$.float2double(s)));
            }
            return this.config().convert(s);
        }
        throw new MatchError(option);
    }

    public boolean passed(Option<Object> score) {
        if (this.config() == null || score == null || score.isEmpty()) {
            return false;
        }
        return Float.compare(BoxesRunTime.unboxToFloat((Object)score.get()), this.config().passScore()) >= 0;
    }

    public Option<Object> convert(String score) {
        if (Strings$.MODULE$.isBlank((CharSequence)score)) {
            return null;
        }
        if (this.config() == null || this.config().items().isEmpty()) {
            if (Numbers$.MODULE$.isDigits(score)) {
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Numbers$.MODULE$.toFloat(score, Numbers$.MODULE$.toFloat$default$2())));
            }
            return None$.MODULE$;
        }
        Option option = this.defaultScoreMap.get((Object)score);
        if (None$.MODULE$.equals(option)) {
            if (Numbers$.MODULE$.isDigits(score)) {
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Numbers$.MODULE$.toFloat(score, Numbers$.MODULE$.toFloat$default$2())));
            }
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Some p = (Some)option;
            return p;
        }
        throw new MatchError((Object)option);
    }

    public Option<Object> calcGp(Option<Object> score) {
        if (score == null || score.isEmpty() || BoxesRunTime.unboxToFloat((Object)score.get()) <= 0.0f) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.0f));
        }
        float s = BoxesRunTime.unboxToFloat((Object)score.get());
        Option option = this.config().items().find((Function1 & Serializable)_$1 -> _$1.contains(s));
        if (option instanceof Some) {
            GradeRateItem gri = (GradeRateItem)((Some)option).value();
            Option option2 = gri.gpExp();
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                String exp = (String)((Some)option2).value();
                if (exp.contains("score")) {
                    HashMap<String, Float> data = new HashMap<String, Float>();
                    data.put("score", BoxesRunTime.boxToFloat((float)s));
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)((Float)this.expressionEvaluator().eval(exp, data, Float.class)).floatValue()));
                }
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Numbers$.MODULE$.toFloat(exp, Numbers$.MODULE$.toFloat$default$2())));
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.0f));
        }
        throw new MatchError((Object)option);
    }
}

