/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.impl;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.domain.CourseGradeProvider;
import org.openurp.edu.grade.domain.DefaultPlanAuditor;
import org.openurp.edu.grade.domain.PlanAuditContext;
import org.openurp.edu.grade.domain.PlanAuditListener;
import org.openurp.edu.grade.domain.StdGrade;
import org.openurp.edu.grade.model.PlanAuditResult;
import org.openurp.edu.grade.service.PlanAuditService;
import org.openurp.edu.grade.service.impl.PlanAuditPersister$;
import org.openurp.edu.program.domain.CoursePlanProvider;
import org.openurp.edu.program.model.CoursePlan;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class PlanAuditServiceImpl
extends DefaultPlanAuditor
implements PlanAuditService,
Logging {
    private Logger logger;
    private EntityDao entityDao;
    private CoursePlanProvider coursePlanProvider;
    private CourseGradeProvider courseGradeProvider;
    private Buffer listeners;

    public PlanAuditServiceImpl() {
        Logging.$init$((Logging)this);
        this.listeners = Collections$.MODULE$.newBuffer();
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public CoursePlanProvider coursePlanProvider() {
        return this.coursePlanProvider;
    }

    public void coursePlanProvider_$eq(CoursePlanProvider x$1) {
        this.coursePlanProvider = x$1;
    }

    public CourseGradeProvider courseGradeProvider() {
        return this.courseGradeProvider;
    }

    public void courseGradeProvider_$eq(CourseGradeProvider x$1) {
        this.courseGradeProvider = x$1;
    }

    public Buffer<PlanAuditListener> listeners() {
        return this.listeners;
    }

    public void listeners_$eq(Buffer<PlanAuditListener> x$1) {
        this.listeners = x$1;
    }

    @Override
    public PlanAuditResult audit(Student std, Map<String, Object> params, boolean persist) {
        Logger$.MODULE$.debug$extension(this.logger(), () -> PlanAuditServiceImpl.audit$$anonfun$1(std));
        CoursePlan coursePlan = (CoursePlan)this.coursePlanProvider().getCoursePlan(std).get();
        StdGrade stdGrade = new StdGrade(this.courseGradeProvider().getPublished(std));
        PlanAuditContext context = new PlanAuditContext(std, coursePlan, stdGrade, this.listeners());
        context.params().$plus$plus$eq(params);
        PlanAuditResult planAuditResult = this.audit(context);
        if (persist) {
            PlanAuditPersister$.MODULE$.save(planAuditResult, this.entityDao());
        }
        return planAuditResult;
    }

    @Override
    public Option<PlanAuditResult> getResult(Student std) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(PlanAuditResult.class, "planResult");
        query.where("planResult.std = :std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    @Override
    public void batchAudit(Iterable<Student> stds, Map<String, Object> params) {
        stds.foreach((Function1 & Serializable)std -> this.audit((Student)std, params, true));
    }

    private static final String audit$$anonfun$1(Student std$1) {
        return "start audit " + std$1.code();
    }
}

