/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.audit;

import java.io.Serializable;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.grade.domain.AuditPlanContext;
import org.openurp.edu.grade.domain.AuditPlanListener;
import org.openurp.edu.grade.model.AuditCourseResult;
import org.openurp.edu.grade.model.AuditGroupResult;
import org.openurp.edu.grade.model.AuditPlanResult;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.Grade;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class AuditCourseTakerListener
implements AuditPlanListener {
    private EntityDao entityDao;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public void end(AuditPlanContext context) {
        if (context.result().passed()) {
            return;
        }
        OqlBuilder builder = (OqlBuilder)OqlBuilder$.MODULE$.from(CourseTaker.class, "ct").where("ct.std=:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{context.std()}));
        builder.where("not exists(from " + CourseGrade.class.getName() + " cg where cg.semester=ct.clazz.semester and cg.course=ct.clazz.course and cg.std=ct.std and cg.status=:status)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Grade.Status$.MODULE$.Published())}));
        Seq courseTakers = this.entityDao().search((QueryBuilder)builder);
        Option<AuditGroupResult> last = this.getTargetGroupResult(context);
        AuditPlanResult result = context.result();
        courseTakers.foreach((Function1)(JProcedure1 & Serializable)ct -> {
            CourseType courseType = ct.courseType();
            if (courseType == null) {
                courseType = ct.clazz().courseType();
            }
            Option target = context.getGroup(ct.course(), courseType).flatMap((Function1 & Serializable)x -> result.getGroupResult(x.name())).orElse(() -> AuditCourseTakerListener.$anonfun$2(last));
            target.foreach((Function1)(JProcedure1 & Serializable)t -> this.add2Group((CourseTaker)ct, (AuditGroupResult)t, last.contains(t)));
        });
    }

    private void add2Group(CourseTaker taker, AuditGroupResult groupResult, boolean isLast) {
        AuditCourseResult cr = (AuditCourseResult)groupResult.getCourseResult(taker.course()).getOrElse(() -> AuditCourseTakerListener.$anonfun$3(taker));
        cr.taking_$eq(true);
        groupResult.addCourseResult(cr);
        cr.addRemark("\u5728\u8bfb");
        CourseType courseType = taker.courseType();
        if (courseType == null) {
            courseType = taker.clazz().courseType();
        }
        if (isLast) {
            CourseType courseType2 = courseType;
            CourseType courseType3 = groupResult.courseType();
            if (courseType2 == null ? courseType3 != null : !courseType2.equals(courseType3)) {
                cr.addRemark("\u539f" + courseType.name());
                return;
            }
        }
    }

    private Option<AuditGroupResult> getTargetGroupResult(AuditPlanContext context) {
        AuditPlanResult result = context.result();
        return context.coursePlan().program().offsetType().map((Function1 & Serializable)electiveType -> {
            AuditGroupResult groupResult = (AuditGroupResult)result.getGroupResult(electiveType.name()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (groupResult == null) {
                AuditGroupResult groupRs = new AuditGroupResult(electiveType.name(), electiveType);
                groupRs.indexno_$eq("99.99");
                groupResult = groupRs;
                result.addGroupResult(groupResult);
            }
            return groupResult;
        });
    }

    private static final Option $anonfun$2(Option last$2) {
        return last$2;
    }

    private static final AuditCourseResult $anonfun$3(CourseTaker taker$1) {
        return new AuditCourseResult(taker$1.course());
    }
}

